/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.AnomalyDetectorConfiguration;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.PutAnomalyDetectorRequest;
import com.amazonaws.services.cloudwatch.model.Range;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class PutAnomalyDetectorRequestMarshaller
implements Marshaller<Request<PutAnomalyDetectorRequest>, PutAnomalyDetectorRequest> {
    public Request<PutAnomalyDetectorRequest> marshall(PutAnomalyDetectorRequest putAnomalyDetectorRequest) {
        AnomalyDetectorConfiguration configuration;
        if (putAnomalyDetectorRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putAnomalyDetectorRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutAnomalyDetector");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putAnomalyDetectorRequest.getNamespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString((String)putAnomalyDetectorRequest.getNamespace()));
        }
        if (putAnomalyDetectorRequest.getMetricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString((String)putAnomalyDetectorRequest.getMetricName()));
        }
        if (!putAnomalyDetectorRequest.getDimensions().isEmpty() || !((SdkInternalList)putAnomalyDetectorRequest.getDimensions()).isAutoConstruct()) {
            SdkInternalList dimensionsList = (SdkInternalList)putAnomalyDetectorRequest.getDimensions();
            int dimensionsListIndex = 1;
            for (Dimension dimensionsListValue : dimensionsList) {
                if (dimensionsListValue != null) {
                    if (dimensionsListValue.getName() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.getName()));
                    }
                    if (dimensionsListValue.getValue() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.getValue()));
                    }
                }
                ++dimensionsListIndex;
            }
        }
        if (putAnomalyDetectorRequest.getStat() != null) {
            request.addParameter("Stat", StringUtils.fromString((String)putAnomalyDetectorRequest.getStat()));
        }
        if ((configuration = putAnomalyDetectorRequest.getConfiguration()) != null) {
            if (!configuration.getExcludedTimeRanges().isEmpty() || !((SdkInternalList)configuration.getExcludedTimeRanges()).isAutoConstruct()) {
                SdkInternalList excludedTimeRangesList = (SdkInternalList)configuration.getExcludedTimeRanges();
                int excludedTimeRangesListIndex = 1;
                for (Range excludedTimeRangesListValue : excludedTimeRangesList) {
                    if (excludedTimeRangesListValue != null) {
                        if (excludedTimeRangesListValue.getStartTime() != null) {
                            request.addParameter("Configuration.ExcludedTimeRanges.member." + excludedTimeRangesListIndex + ".StartTime", StringUtils.fromDate((Date)excludedTimeRangesListValue.getStartTime()));
                        }
                        if (excludedTimeRangesListValue.getEndTime() != null) {
                            request.addParameter("Configuration.ExcludedTimeRanges.member." + excludedTimeRangesListIndex + ".EndTime", StringUtils.fromDate((Date)excludedTimeRangesListValue.getEndTime()));
                        }
                    }
                    ++excludedTimeRangesListIndex;
                }
            }
            if (configuration.getMetricTimezone() != null) {
                request.addParameter("Configuration.MetricTimezone", StringUtils.fromString((String)configuration.getMetricTimezone()));
            }
        }
        return request;
    }
}

