/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.utils;

import com.amazonaws.codegen.model.service.ServiceMetadata;
import java.util.Arrays;
import java.util.List;

public class ProtocolUtils {
    private static final List<String> SUPPORTED_PROTOCOLS = Arrays.asList("json", "rest-json", "rest-xml", "query", "ec2");

    private ProtocolUtils() {
    }

    public static String resolveProtocol(ServiceMetadata serviceMetadata) {
        List<String> protocols = serviceMetadata.getProtocols();
        String protocol = serviceMetadata.getProtocol();
        if (protocol != null && protocol.equals("api-gateway")) {
            return "api-gateway";
        }
        if (protocols == null || protocols.isEmpty()) {
            if ("smithy-rpc-v2-cbor".equals(protocol)) {
                throw new IllegalArgumentException("Java v1 SDK does not support smithy-rpc-v2-cbor protocol");
            }
            return protocol;
        }
        if ("cbor".equals(protocols.get(0))) {
            return "cbor";
        }
        for (String supportedProtocol : SUPPORTED_PROTOCOLS) {
            if (!protocols.contains(supportedProtocol)) continue;
            return supportedProtocol;
        }
        throw new IllegalArgumentException("Java v1 SDK does not support any of provided protocols: " + protocols);
    }
}

