/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.customization.processors;

import com.amazonaws.codegen.customization.CodegenCustomizationProcessor;
import com.amazonaws.codegen.model.config.customization.MetadataConfig;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.intermediate.Metadata;
import com.amazonaws.codegen.model.service.ServiceMetadata;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.protocol.ProtocolSelector;
import java.util.Collections;

public class MetadataModifiersProcessor
implements CodegenCustomizationProcessor {
    private final MetadataConfig metadataConfig;

    MetadataModifiersProcessor(MetadataConfig metadataConfig) {
        this.metadataConfig = metadataConfig;
    }

    @Override
    public void preprocess(ServiceModel serviceModel) {
        serviceModel.getMetadata().setProtocol(ProtocolSelector.selectProtocol(serviceModel.getMetadata().getProtocol(), serviceModel.getMetadata().getProtocols()));
        if (this.metadataConfig == null) {
            return;
        }
        ServiceMetadata serviceMetadata = serviceModel.getMetadata();
        String customProtocol = this.metadataConfig.getProtocol();
        if (customProtocol != null) {
            serviceMetadata.setProtocols(Collections.singletonList(customProtocol));
        }
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
        if (this.metadataConfig == null) {
            return;
        }
        Metadata metadata = intermediateModel.getMetadata();
        String contentType = this.metadataConfig.getContentType();
        if (contentType != null) {
            metadata.setContentType(contentType);
        }
    }
}

