/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.codeartifact;

import javax.annotation.Generated;

import com.amazonaws.services.codeartifact.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSCodeArtifact}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSCodeArtifact implements AWSCodeArtifact {

    protected AbstractAWSCodeArtifact() {
    }

    @Override
    public AssociateExternalConnectionResult associateExternalConnection(AssociateExternalConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CopyPackageVersionsResult copyPackageVersions(CopyPackageVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDomainResult createDomain(CreateDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRepositoryResult createRepository(CreateRepositoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDomainResult deleteDomain(DeleteDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDomainPermissionsPolicyResult deleteDomainPermissionsPolicy(DeleteDomainPermissionsPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePackageVersionsResult deletePackageVersions(DeletePackageVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRepositoryResult deleteRepository(DeleteRepositoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRepositoryPermissionsPolicyResult deleteRepositoryPermissionsPolicy(DeleteRepositoryPermissionsPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDomainResult describeDomain(DescribeDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePackageVersionResult describePackageVersion(DescribePackageVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRepositoryResult describeRepository(DescribeRepositoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateExternalConnectionResult disassociateExternalConnection(DisassociateExternalConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisposePackageVersionsResult disposePackageVersions(DisposePackageVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAuthorizationTokenResult getAuthorizationToken(GetAuthorizationTokenRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDomainPermissionsPolicyResult getDomainPermissionsPolicy(GetDomainPermissionsPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPackageVersionAssetResult getPackageVersionAsset(GetPackageVersionAssetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPackageVersionReadmeResult getPackageVersionReadme(GetPackageVersionReadmeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRepositoryEndpointResult getRepositoryEndpoint(GetRepositoryEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRepositoryPermissionsPolicyResult getRepositoryPermissionsPolicy(GetRepositoryPermissionsPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDomainsResult listDomains(ListDomainsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPackageVersionAssetsResult listPackageVersionAssets(ListPackageVersionAssetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPackageVersionDependenciesResult listPackageVersionDependencies(ListPackageVersionDependenciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPackageVersionsResult listPackageVersions(ListPackageVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPackagesResult listPackages(ListPackagesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRepositoriesResult listRepositories(ListRepositoriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRepositoriesInDomainResult listRepositoriesInDomain(ListRepositoriesInDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutDomainPermissionsPolicyResult putDomainPermissionsPolicy(PutDomainPermissionsPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutRepositoryPermissionsPolicyResult putRepositoryPermissionsPolicy(PutRepositoryPermissionsPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePackageVersionsStatusResult updatePackageVersionsStatus(UpdatePackageVersionsStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRepositoryResult updateRepository(UpdateRepositoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
