/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codebuild.model.BuildPhase;
import com.amazonaws.services.codebuild.model.PhaseContext;
import com.amazonaws.services.codebuild.model.transform.PhaseContextJsonMarshaller;
import java.util.List;

public class BuildPhaseJsonMarshaller {
    private static BuildPhaseJsonMarshaller instance;

    public void marshall(BuildPhase buildPhase, StructuredJsonGenerator jsonGenerator) {
        if (buildPhase == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<PhaseContext> contextsList;
            jsonGenerator.writeStartObject();
            if (buildPhase.getPhaseType() != null) {
                jsonGenerator.writeFieldName("phaseType").writeValue(buildPhase.getPhaseType());
            }
            if (buildPhase.getPhaseStatus() != null) {
                jsonGenerator.writeFieldName("phaseStatus").writeValue(buildPhase.getPhaseStatus());
            }
            if (buildPhase.getStartTime() != null) {
                jsonGenerator.writeFieldName("startTime").writeValue(buildPhase.getStartTime());
            }
            if (buildPhase.getEndTime() != null) {
                jsonGenerator.writeFieldName("endTime").writeValue(buildPhase.getEndTime());
            }
            if (buildPhase.getDurationInSeconds() != null) {
                jsonGenerator.writeFieldName("durationInSeconds").writeValue(buildPhase.getDurationInSeconds().longValue());
            }
            if ((contextsList = buildPhase.getContexts()) != null) {
                jsonGenerator.writeFieldName("contexts");
                jsonGenerator.writeStartArray();
                for (PhaseContext contextsListValue : contextsList) {
                    if (contextsListValue == null) continue;
                    PhaseContextJsonMarshaller.getInstance().marshall(contextsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static BuildPhaseJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new BuildPhaseJsonMarshaller();
        }
        return instance;
    }
}

