/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.DeploymentConfigInfo;
import com.amazonaws.services.codedeploy.model.transform.MinimumHealthyHostsJsonMarshaller;

public class DeploymentConfigInfoJsonMarshaller {
    private static DeploymentConfigInfoJsonMarshaller instance;

    public void marshall(DeploymentConfigInfo deploymentConfigInfo, StructuredJsonGenerator jsonGenerator) {
        if (deploymentConfigInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (deploymentConfigInfo.getDeploymentConfigId() != null) {
                jsonGenerator.writeFieldName("deploymentConfigId").writeValue(deploymentConfigInfo.getDeploymentConfigId());
            }
            if (deploymentConfigInfo.getDeploymentConfigName() != null) {
                jsonGenerator.writeFieldName("deploymentConfigName").writeValue(deploymentConfigInfo.getDeploymentConfigName());
            }
            if (deploymentConfigInfo.getMinimumHealthyHosts() != null) {
                jsonGenerator.writeFieldName("minimumHealthyHosts");
                MinimumHealthyHostsJsonMarshaller.getInstance().marshall(deploymentConfigInfo.getMinimumHealthyHosts(), jsonGenerator);
            }
            if (deploymentConfigInfo.getCreateTime() != null) {
                jsonGenerator.writeFieldName("createTime").writeValue(deploymentConfigInfo.getCreateTime());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeploymentConfigInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeploymentConfigInfoJsonMarshaller();
        }
        return instance;
    }
}

