/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.BatchGetApplicationsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class BatchGetApplicationsRequestMarshaller
implements Marshaller<Request<BatchGetApplicationsRequest>, BatchGetApplicationsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public BatchGetApplicationsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<BatchGetApplicationsRequest> marshall(BatchGetApplicationsRequest batchGetApplicationsRequest) {
        if (batchGetApplicationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)batchGetApplicationsRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.BatchGetApplications");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList applicationNamesList = (SdkInternalList)batchGetApplicationsRequest.getApplicationNames();
            if (!applicationNamesList.isEmpty() || !applicationNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("applicationNames");
                jsonGenerator.writeStartArray();
                for (String applicationNamesListValue : applicationNamesList) {
                    if (applicationNamesListValue == null) continue;
                    jsonGenerator.writeValue(applicationNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

