/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.codedeploy.model.EC2TagFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateDeploymentGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationName;
    private String currentDeploymentGroupName;
    private String newDeploymentGroupName;
    private String deploymentConfigName;
    private ListWithAutoConstructFlag<EC2TagFilter> ec2TagFilters;
    private ListWithAutoConstructFlag<String> autoScalingGroups;
    private String serviceRoleArn;

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public UpdateDeploymentGroupRequest withApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public String getCurrentDeploymentGroupName() {
        return this.currentDeploymentGroupName;
    }

    public void setCurrentDeploymentGroupName(String currentDeploymentGroupName) {
        this.currentDeploymentGroupName = currentDeploymentGroupName;
    }

    public UpdateDeploymentGroupRequest withCurrentDeploymentGroupName(String currentDeploymentGroupName) {
        this.currentDeploymentGroupName = currentDeploymentGroupName;
        return this;
    }

    public String getNewDeploymentGroupName() {
        return this.newDeploymentGroupName;
    }

    public void setNewDeploymentGroupName(String newDeploymentGroupName) {
        this.newDeploymentGroupName = newDeploymentGroupName;
    }

    public UpdateDeploymentGroupRequest withNewDeploymentGroupName(String newDeploymentGroupName) {
        this.newDeploymentGroupName = newDeploymentGroupName;
        return this;
    }

    public String getDeploymentConfigName() {
        return this.deploymentConfigName;
    }

    public void setDeploymentConfigName(String deploymentConfigName) {
        this.deploymentConfigName = deploymentConfigName;
    }

    public UpdateDeploymentGroupRequest withDeploymentConfigName(String deploymentConfigName) {
        this.deploymentConfigName = deploymentConfigName;
        return this;
    }

    public List<EC2TagFilter> getEc2TagFilters() {
        if (this.ec2TagFilters == null) {
            this.ec2TagFilters = new ListWithAutoConstructFlag();
            this.ec2TagFilters.setAutoConstruct(true);
        }
        return this.ec2TagFilters;
    }

    public void setEc2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
        if (ec2TagFilters == null) {
            this.ec2TagFilters = null;
            return;
        }
        ListWithAutoConstructFlag ec2TagFiltersCopy = new ListWithAutoConstructFlag(ec2TagFilters.size());
        ec2TagFiltersCopy.addAll(ec2TagFilters);
        this.ec2TagFilters = ec2TagFiltersCopy;
    }

    public UpdateDeploymentGroupRequest withEc2TagFilters(EC2TagFilter ... ec2TagFilters) {
        if (this.getEc2TagFilters() == null) {
            this.setEc2TagFilters(new ArrayList<EC2TagFilter>(ec2TagFilters.length));
        }
        for (EC2TagFilter value : ec2TagFilters) {
            this.getEc2TagFilters().add(value);
        }
        return this;
    }

    public UpdateDeploymentGroupRequest withEc2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
        if (ec2TagFilters == null) {
            this.ec2TagFilters = null;
        } else {
            ListWithAutoConstructFlag ec2TagFiltersCopy = new ListWithAutoConstructFlag(ec2TagFilters.size());
            ec2TagFiltersCopy.addAll(ec2TagFilters);
            this.ec2TagFilters = ec2TagFiltersCopy;
        }
        return this;
    }

    public List<String> getAutoScalingGroups() {
        if (this.autoScalingGroups == null) {
            this.autoScalingGroups = new ListWithAutoConstructFlag();
            this.autoScalingGroups.setAutoConstruct(true);
        }
        return this.autoScalingGroups;
    }

    public void setAutoScalingGroups(Collection<String> autoScalingGroups) {
        if (autoScalingGroups == null) {
            this.autoScalingGroups = null;
            return;
        }
        ListWithAutoConstructFlag autoScalingGroupsCopy = new ListWithAutoConstructFlag(autoScalingGroups.size());
        autoScalingGroupsCopy.addAll(autoScalingGroups);
        this.autoScalingGroups = autoScalingGroupsCopy;
    }

    public UpdateDeploymentGroupRequest withAutoScalingGroups(String ... autoScalingGroups) {
        if (this.getAutoScalingGroups() == null) {
            this.setAutoScalingGroups(new ArrayList<String>(autoScalingGroups.length));
        }
        for (String value : autoScalingGroups) {
            this.getAutoScalingGroups().add(value);
        }
        return this;
    }

    public UpdateDeploymentGroupRequest withAutoScalingGroups(Collection<String> autoScalingGroups) {
        if (autoScalingGroups == null) {
            this.autoScalingGroups = null;
        } else {
            ListWithAutoConstructFlag autoScalingGroupsCopy = new ListWithAutoConstructFlag(autoScalingGroups.size());
            autoScalingGroupsCopy.addAll(autoScalingGroups);
            this.autoScalingGroups = autoScalingGroupsCopy;
        }
        return this;
    }

    public String getServiceRoleArn() {
        return this.serviceRoleArn;
    }

    public void setServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
    }

    public UpdateDeploymentGroupRequest withServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: " + this.getApplicationName() + ",");
        }
        if (this.getCurrentDeploymentGroupName() != null) {
            sb.append("CurrentDeploymentGroupName: " + this.getCurrentDeploymentGroupName() + ",");
        }
        if (this.getNewDeploymentGroupName() != null) {
            sb.append("NewDeploymentGroupName: " + this.getNewDeploymentGroupName() + ",");
        }
        if (this.getDeploymentConfigName() != null) {
            sb.append("DeploymentConfigName: " + this.getDeploymentConfigName() + ",");
        }
        if (this.getEc2TagFilters() != null) {
            sb.append("Ec2TagFilters: " + this.getEc2TagFilters() + ",");
        }
        if (this.getAutoScalingGroups() != null) {
            sb.append("AutoScalingGroups: " + this.getAutoScalingGroups() + ",");
        }
        if (this.getServiceRoleArn() != null) {
            sb.append("ServiceRoleArn: " + this.getServiceRoleArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentDeploymentGroupName() == null ? 0 : this.getCurrentDeploymentGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getNewDeploymentGroupName() == null ? 0 : this.getNewDeploymentGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentConfigName() == null ? 0 : this.getDeploymentConfigName().hashCode());
        hashCode = 31 * hashCode + (this.getEc2TagFilters() == null ? 0 : this.getEc2TagFilters().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroups() == null ? 0 : this.getAutoScalingGroups().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRoleArn() == null ? 0 : this.getServiceRoleArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeploymentGroupRequest)) {
            return false;
        }
        UpdateDeploymentGroupRequest other = (UpdateDeploymentGroupRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getCurrentDeploymentGroupName() == null ^ this.getCurrentDeploymentGroupName() == null) {
            return false;
        }
        if (other.getCurrentDeploymentGroupName() != null && !other.getCurrentDeploymentGroupName().equals(this.getCurrentDeploymentGroupName())) {
            return false;
        }
        if (other.getNewDeploymentGroupName() == null ^ this.getNewDeploymentGroupName() == null) {
            return false;
        }
        if (other.getNewDeploymentGroupName() != null && !other.getNewDeploymentGroupName().equals(this.getNewDeploymentGroupName())) {
            return false;
        }
        if (other.getDeploymentConfigName() == null ^ this.getDeploymentConfigName() == null) {
            return false;
        }
        if (other.getDeploymentConfigName() != null && !other.getDeploymentConfigName().equals(this.getDeploymentConfigName())) {
            return false;
        }
        if (other.getEc2TagFilters() == null ^ this.getEc2TagFilters() == null) {
            return false;
        }
        if (other.getEc2TagFilters() != null && !other.getEc2TagFilters().equals(this.getEc2TagFilters())) {
            return false;
        }
        if (other.getAutoScalingGroups() == null ^ this.getAutoScalingGroups() == null) {
            return false;
        }
        if (other.getAutoScalingGroups() != null && !other.getAutoScalingGroups().equals(this.getAutoScalingGroups())) {
            return false;
        }
        if (other.getServiceRoleArn() == null ^ this.getServiceRoleArn() == null) {
            return false;
        }
        return other.getServiceRoleArn() == null || other.getServiceRoleArn().equals(this.getServiceRoleArn());
    }

    public UpdateDeploymentGroupRequest clone() {
        return (UpdateDeploymentGroupRequest)super.clone();
    }
}

