/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDeploymentGroupsResult
implements Serializable,
Cloneable {
    private String applicationName;
    private ListWithAutoConstructFlag<String> deploymentGroups;
    private String nextToken;

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public ListDeploymentGroupsResult withApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public List<String> getDeploymentGroups() {
        if (this.deploymentGroups == null) {
            this.deploymentGroups = new ListWithAutoConstructFlag();
            this.deploymentGroups.setAutoConstruct(true);
        }
        return this.deploymentGroups;
    }

    public void setDeploymentGroups(Collection<String> deploymentGroups) {
        if (deploymentGroups == null) {
            this.deploymentGroups = null;
            return;
        }
        ListWithAutoConstructFlag deploymentGroupsCopy = new ListWithAutoConstructFlag(deploymentGroups.size());
        deploymentGroupsCopy.addAll(deploymentGroups);
        this.deploymentGroups = deploymentGroupsCopy;
    }

    public ListDeploymentGroupsResult withDeploymentGroups(String ... deploymentGroups) {
        if (this.getDeploymentGroups() == null) {
            this.setDeploymentGroups(new ArrayList<String>(deploymentGroups.length));
        }
        for (String value : deploymentGroups) {
            this.getDeploymentGroups().add(value);
        }
        return this;
    }

    public ListDeploymentGroupsResult withDeploymentGroups(Collection<String> deploymentGroups) {
        if (deploymentGroups == null) {
            this.deploymentGroups = null;
        } else {
            ListWithAutoConstructFlag deploymentGroupsCopy = new ListWithAutoConstructFlag(deploymentGroups.size());
            deploymentGroupsCopy.addAll(deploymentGroups);
            this.deploymentGroups = deploymentGroupsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListDeploymentGroupsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: " + this.getApplicationName() + ",");
        }
        if (this.getDeploymentGroups() != null) {
            sb.append("DeploymentGroups: " + this.getDeploymentGroups() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentGroups() == null ? 0 : this.getDeploymentGroups().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentGroupsResult)) {
            return false;
        }
        ListDeploymentGroupsResult other = (ListDeploymentGroupsResult)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getDeploymentGroups() == null ^ this.getDeploymentGroups() == null) {
            return false;
        }
        if (other.getDeploymentGroups() != null && !other.getDeploymentGroups().equals(this.getDeploymentGroups())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public ListDeploymentGroupsResult clone() {
        try {
            return (ListDeploymentGroupsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

