/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.maven.plugin;

import com.amazonaws.codegen.C2jModels;
import com.amazonaws.codegen.CodeGenerator;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.BasicCodeGenConfig;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.intermediate.ServiceExamples;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.model.service.Waiters;
import com.amazonaws.codegen.utils.ModelLoaderUtils;
import java.io.File;
import java.util.Optional;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate")
public class GenerationMojo
extends AbstractMojo {
    @Parameter(property="modelFile", defaultValue="code-gen/service-2.json")
    private String serviceModelLocation;
    @Parameter(property="codeGenConfigFile", defaultValue="code-gen/codegen.config")
    private String codeGenConfigLocation;
    @Parameter(property="customizationConfigFile", defaultValue="code-gen/customization.config")
    private String customizationConfigLocation;
    @Parameter(property="examplesFile", defaultValue="code-gen/examples-1.json")
    private String serviceExamplesLocation;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-src")
    private String outputDirectory;
    @Parameter(property="resourcesDirectory", defaultValue="${basedir}/src/main/resources")
    private String resourcesDirectory;
    @Component
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        this.generateCode(C2jModels.builder().codeGenConfig(this.loadCodeGenConfig()).customizationConfig(this.loadCustomizationConfig()).serviceModel(this.loadServiceModel()).waitersModel(Waiters.NONE).examplesModel(this.loadExamplesModel()).build());
        this.project.addCompileSourceRoot(this.outputDirectory);
    }

    private void generateCode(C2jModels models) {
        new CodeGenerator(models, this.outputDirectory, this.resourcesDirectory, Utils.getFileNamePrefix((ServiceModel)models.serviceModel(), (CustomizationConfig)models.customizationConfig())).execute();
    }

    private BasicCodeGenConfig loadCodeGenConfig() throws MojoExecutionException {
        return this.loadRequiredModel(BasicCodeGenConfig.class, this.codeGenConfigLocation);
    }

    private CustomizationConfig loadCustomizationConfig() {
        return this.loadOptionalModel(CustomizationConfig.class, this.customizationConfigLocation).orElse(CustomizationConfig.DEFAULT);
    }

    private ServiceModel loadServiceModel() throws MojoExecutionException {
        return this.loadRequiredModel(ServiceModel.class, this.serviceModelLocation);
    }

    private ServiceExamples loadExamplesModel() {
        return this.loadOptionalModel(ServiceExamples.class, this.serviceExamplesLocation).orElse(ServiceExamples.NONE);
    }

    private <T> T loadRequiredModel(Class<T> clzz, String location) throws MojoExecutionException {
        return (T)ModelLoaderUtils.loadModel(clzz, (File)this.getResourceLocation(location));
    }

    private <T> Optional<T> loadOptionalModel(Class<T> clzz, String location) {
        return ModelLoaderUtils.loadOptionalModel(clzz, (File)this.getResourceLocation(location));
    }

    private File getResourceLocation(String location) {
        return new File(this.resourcesDirectory, location);
    }
}

