/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.codegurureviewer.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Information about recommendations.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/RecommendationSummary"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RecommendationSummary implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Name of the file on which a recommendation is provided.
     * </p>
     */
    private String filePath;
    /**
     * <p>
     * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect
     * the feedback.
     * </p>
     */
    private String recommendationId;
    /**
     * <p>
     * Start line from where the recommendation is applicable in the source commit or source branch.
     * </p>
     */
    private Integer startLine;
    /**
     * <p>
     * Last line where the recommendation is applicable in the source commit or source branch. For a single line comment
     * the start line and end line values are the same.
     * </p>
     */
    private Integer endLine;
    /**
     * <p>
     * A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the start line
     * and the end line.
     * </p>
     */
    private String description;
    /**
     * <p>
     * The type of a recommendation.
     * </p>
     */
    private String recommendationCategory;
    /**
     * <p>
     * Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a short and long description.
     * CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is included in analysis results if code is
     * detected that violates the rule.
     * </p>
     */
    private RuleMetadata ruleMetadata;
    /**
     * <p>
     * The severity of the issue in the code that generated this recommendation.
     * </p>
     */
    private String severity;

    /**
     * <p>
     * Name of the file on which a recommendation is provided.
     * </p>
     * 
     * @param filePath
     *        Name of the file on which a recommendation is provided.
     */

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    /**
     * <p>
     * Name of the file on which a recommendation is provided.
     * </p>
     * 
     * @return Name of the file on which a recommendation is provided.
     */

    public String getFilePath() {
        return this.filePath;
    }

    /**
     * <p>
     * Name of the file on which a recommendation is provided.
     * </p>
     * 
     * @param filePath
     *        Name of the file on which a recommendation is provided.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RecommendationSummary withFilePath(String filePath) {
        setFilePath(filePath);
        return this;
    }

    /**
     * <p>
     * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect
     * the feedback.
     * </p>
     * 
     * @param recommendationId
     *        The recommendation ID that can be used to track the provided recommendations. Later on it can be used to
     *        collect the feedback.
     */

    public void setRecommendationId(String recommendationId) {
        this.recommendationId = recommendationId;
    }

    /**
     * <p>
     * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect
     * the feedback.
     * </p>
     * 
     * @return The recommendation ID that can be used to track the provided recommendations. Later on it can be used to
     *         collect the feedback.
     */

    public String getRecommendationId() {
        return this.recommendationId;
    }

    /**
     * <p>
     * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect
     * the feedback.
     * </p>
     * 
     * @param recommendationId
     *        The recommendation ID that can be used to track the provided recommendations. Later on it can be used to
     *        collect the feedback.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RecommendationSummary withRecommendationId(String recommendationId) {
        setRecommendationId(recommendationId);
        return this;
    }

    /**
     * <p>
     * Start line from where the recommendation is applicable in the source commit or source branch.
     * </p>
     * 
     * @param startLine
     *        Start line from where the recommendation is applicable in the source commit or source branch.
     */

    public void setStartLine(Integer startLine) {
        this.startLine = startLine;
    }

    /**
     * <p>
     * Start line from where the recommendation is applicable in the source commit or source branch.
     * </p>
     * 
     * @return Start line from where the recommendation is applicable in the source commit or source branch.
     */

    public Integer getStartLine() {
        return this.startLine;
    }

    /**
     * <p>
     * Start line from where the recommendation is applicable in the source commit or source branch.
     * </p>
     * 
     * @param startLine
     *        Start line from where the recommendation is applicable in the source commit or source branch.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RecommendationSummary withStartLine(Integer startLine) {
        setStartLine(startLine);
        return this;
    }

    /**
     * <p>
     * Last line where the recommendation is applicable in the source commit or source branch. For a single line comment
     * the start line and end line values are the same.
     * </p>
     * 
     * @param endLine
     *        Last line where the recommendation is applicable in the source commit or source branch. For a single line
     *        comment the start line and end line values are the same.
     */

    public void setEndLine(Integer endLine) {
        this.endLine = endLine;
    }

    /**
     * <p>
     * Last line where the recommendation is applicable in the source commit or source branch. For a single line comment
     * the start line and end line values are the same.
     * </p>
     * 
     * @return Last line where the recommendation is applicable in the source commit or source branch. For a single line
     *         comment the start line and end line values are the same.
     */

    public Integer getEndLine() {
        return this.endLine;
    }

    /**
     * <p>
     * Last line where the recommendation is applicable in the source commit or source branch. For a single line comment
     * the start line and end line values are the same.
     * </p>
     * 
     * @param endLine
     *        Last line where the recommendation is applicable in the source commit or source branch. For a single line
     *        comment the start line and end line values are the same.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RecommendationSummary withEndLine(Integer endLine) {
        setEndLine(endLine);
        return this;
    }

    /**
     * <p>
     * A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the start line
     * and the end line.
     * </p>
     * 
     * @param description
     *        A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the start
     *        line and the end line.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the start line
     * and the end line.
     * </p>
     * 
     * @return A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the
     *         start line and the end line.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the start line
     * and the end line.
     * </p>
     * 
     * @param description
     *        A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the start
     *        line and the end line.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RecommendationSummary withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * The type of a recommendation.
     * </p>
     * 
     * @param recommendationCategory
     *        The type of a recommendation.
     * @see RecommendationCategory
     */

    public void setRecommendationCategory(String recommendationCategory) {
        this.recommendationCategory = recommendationCategory;
    }

    /**
     * <p>
     * The type of a recommendation.
     * </p>
     * 
     * @return The type of a recommendation.
     * @see RecommendationCategory
     */

    public String getRecommendationCategory() {
        return this.recommendationCategory;
    }

    /**
     * <p>
     * The type of a recommendation.
     * </p>
     * 
     * @param recommendationCategory
     *        The type of a recommendation.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RecommendationCategory
     */

    public RecommendationSummary withRecommendationCategory(String recommendationCategory) {
        setRecommendationCategory(recommendationCategory);
        return this;
    }

    /**
     * <p>
     * The type of a recommendation.
     * </p>
     * 
     * @param recommendationCategory
     *        The type of a recommendation.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RecommendationCategory
     */

    public RecommendationSummary withRecommendationCategory(RecommendationCategory recommendationCategory) {
        this.recommendationCategory = recommendationCategory.toString();
        return this;
    }

    /**
     * <p>
     * Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a short and long description.
     * CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is included in analysis results if code is
     * detected that violates the rule.
     * </p>
     * 
     * @param ruleMetadata
     *        Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a short and long
     *        description. CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is included in analysis
     *        results if code is detected that violates the rule.
     */

    public void setRuleMetadata(RuleMetadata ruleMetadata) {
        this.ruleMetadata = ruleMetadata;
    }

    /**
     * <p>
     * Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a short and long description.
     * CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is included in analysis results if code is
     * detected that violates the rule.
     * </p>
     * 
     * @return Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a short and long
     *         description. CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is included in
     *         analysis results if code is detected that violates the rule.
     */

    public RuleMetadata getRuleMetadata() {
        return this.ruleMetadata;
    }

    /**
     * <p>
     * Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a short and long description.
     * CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is included in analysis results if code is
     * detected that violates the rule.
     * </p>
     * 
     * @param ruleMetadata
     *        Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a short and long
     *        description. CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is included in analysis
     *        results if code is detected that violates the rule.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RecommendationSummary withRuleMetadata(RuleMetadata ruleMetadata) {
        setRuleMetadata(ruleMetadata);
        return this;
    }

    /**
     * <p>
     * The severity of the issue in the code that generated this recommendation.
     * </p>
     * 
     * @param severity
     *        The severity of the issue in the code that generated this recommendation.
     * @see Severity
     */

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    /**
     * <p>
     * The severity of the issue in the code that generated this recommendation.
     * </p>
     * 
     * @return The severity of the issue in the code that generated this recommendation.
     * @see Severity
     */

    public String getSeverity() {
        return this.severity;
    }

    /**
     * <p>
     * The severity of the issue in the code that generated this recommendation.
     * </p>
     * 
     * @param severity
     *        The severity of the issue in the code that generated this recommendation.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Severity
     */

    public RecommendationSummary withSeverity(String severity) {
        setSeverity(severity);
        return this;
    }

    /**
     * <p>
     * The severity of the issue in the code that generated this recommendation.
     * </p>
     * 
     * @param severity
     *        The severity of the issue in the code that generated this recommendation.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Severity
     */

    public RecommendationSummary withSeverity(Severity severity) {
        this.severity = severity.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getFilePath() != null)
            sb.append("FilePath: ").append(getFilePath()).append(",");
        if (getRecommendationId() != null)
            sb.append("RecommendationId: ").append(getRecommendationId()).append(",");
        if (getStartLine() != null)
            sb.append("StartLine: ").append(getStartLine()).append(",");
        if (getEndLine() != null)
            sb.append("EndLine: ").append(getEndLine()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getRecommendationCategory() != null)
            sb.append("RecommendationCategory: ").append(getRecommendationCategory()).append(",");
        if (getRuleMetadata() != null)
            sb.append("RuleMetadata: ").append(getRuleMetadata()).append(",");
        if (getSeverity() != null)
            sb.append("Severity: ").append(getSeverity());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RecommendationSummary == false)
            return false;
        RecommendationSummary other = (RecommendationSummary) obj;
        if (other.getFilePath() == null ^ this.getFilePath() == null)
            return false;
        if (other.getFilePath() != null && other.getFilePath().equals(this.getFilePath()) == false)
            return false;
        if (other.getRecommendationId() == null ^ this.getRecommendationId() == null)
            return false;
        if (other.getRecommendationId() != null && other.getRecommendationId().equals(this.getRecommendationId()) == false)
            return false;
        if (other.getStartLine() == null ^ this.getStartLine() == null)
            return false;
        if (other.getStartLine() != null && other.getStartLine().equals(this.getStartLine()) == false)
            return false;
        if (other.getEndLine() == null ^ this.getEndLine() == null)
            return false;
        if (other.getEndLine() != null && other.getEndLine().equals(this.getEndLine()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getRecommendationCategory() == null ^ this.getRecommendationCategory() == null)
            return false;
        if (other.getRecommendationCategory() != null && other.getRecommendationCategory().equals(this.getRecommendationCategory()) == false)
            return false;
        if (other.getRuleMetadata() == null ^ this.getRuleMetadata() == null)
            return false;
        if (other.getRuleMetadata() != null && other.getRuleMetadata().equals(this.getRuleMetadata()) == false)
            return false;
        if (other.getSeverity() == null ^ this.getSeverity() == null)
            return false;
        if (other.getSeverity() != null && other.getSeverity().equals(this.getSeverity()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getFilePath() == null) ? 0 : getFilePath().hashCode());
        hashCode = prime * hashCode + ((getRecommendationId() == null) ? 0 : getRecommendationId().hashCode());
        hashCode = prime * hashCode + ((getStartLine() == null) ? 0 : getStartLine().hashCode());
        hashCode = prime * hashCode + ((getEndLine() == null) ? 0 : getEndLine().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getRecommendationCategory() == null) ? 0 : getRecommendationCategory().hashCode());
        hashCode = prime * hashCode + ((getRuleMetadata() == null) ? 0 : getRuleMetadata().hashCode());
        hashCode = prime * hashCode + ((getSeverity() == null) ? 0 : getSeverity().hashCode());
        return hashCode;
    }

    @Override
    public RecommendationSummary clone() {
        try {
            return (RecommendationSummary) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.codegurureviewer.model.transform.RecommendationSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
