/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurureviewer.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.codegurureviewer.AmazonCodeGuruReviewer;
import com.amazonaws.services.codegurureviewer.model.DescribeCodeReviewRequest;
import com.amazonaws.services.codegurureviewer.model.DescribeRepositoryAssociationRequest;
import com.amazonaws.services.codegurureviewer.waiters.CodeReviewCompleted;
import com.amazonaws.services.codegurureviewer.waiters.DescribeCodeReviewFunction;
import com.amazonaws.services.codegurureviewer.waiters.DescribeRepositoryAssociationFunction;
import com.amazonaws.services.codegurureviewer.waiters.RepositoryAssociationSucceeded;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonCodeGuruReviewerWaiters {
    private final AmazonCodeGuruReviewer client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AmazonCodeGuruReviewerWaiters");

    @SdkInternalApi
    public AmazonCodeGuruReviewerWaiters(AmazonCodeGuruReviewer client) {
        this.client = client;
    }

    public Waiter<DescribeRepositoryAssociationRequest> repositoryAssociationSucceeded() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeRepositoryAssociationFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new RepositoryAssociationSucceeded.IsAssociatedMatcher(), new RepositoryAssociationSucceeded.IsAssociatingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeCodeReviewRequest> codeReviewCompleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeCodeReviewFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new CodeReviewCompleted.IsCompletedMatcher(), new CodeReviewCompleted.IsPendingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

