/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurusecurity.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codegurusecurity.model.CodeLine;

@SdkInternalApi
public class CodeLineMarshaller {
    private static final MarshallingInfo<String> CONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("content").build();
    private static final MarshallingInfo<Integer> NUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("number").build();
    private static final CodeLineMarshaller instance = new CodeLineMarshaller();

    public static CodeLineMarshaller getInstance() {
        return instance;
    }

    public void marshall(CodeLine codeLine, ProtocolMarshaller protocolMarshaller) {
        if (codeLine == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)codeLine.getContent(), CONTENT_BINDING);
            protocolMarshaller.marshall((Object)codeLine.getNumber(), NUMBER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

