/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurusecurity.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codegurusecurity.model.FilePath;
import java.util.List;

@SdkInternalApi
public class FilePathMarshaller {
    private static final MarshallingInfo<List> CODESNIPPET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codeSnippet").build();
    private static final MarshallingInfo<Integer> ENDLINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endLine").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("path").build();
    private static final MarshallingInfo<Integer> STARTLINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startLine").build();
    private static final FilePathMarshaller instance = new FilePathMarshaller();

    public static FilePathMarshaller getInstance() {
        return instance;
    }

    public void marshall(FilePath filePath, ProtocolMarshaller protocolMarshaller) {
        if (filePath == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(filePath.getCodeSnippet(), CODESNIPPET_BINDING);
            protocolMarshaller.marshall((Object)filePath.getEndLine(), ENDLINE_BINDING);
            protocolMarshaller.marshall((Object)filePath.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)filePath.getPath(), PATH_BINDING);
            protocolMarshaller.marshall((Object)filePath.getStartLine(), STARTLINE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

