/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.codegurusecurity.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Information about a security vulnerability that Amazon CodeGuru Security detected.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/Vulnerability" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Vulnerability implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * An object that describes the location of the detected security vulnerability in your code.
     * </p>
     */
    private FilePath filePath;
    /**
     * <p>
     * The identifier for the vulnerability.
     * </p>
     */
    private String id;
    /**
     * <p>
     * The number of times the vulnerability appears in your code.
     * </p>
     */
    @Deprecated
    private Integer itemCount;
    /**
     * <p>
     * One or more URL addresses that contain details about a vulnerability.
     * </p>
     */
    private java.util.List<String> referenceUrls;
    /**
     * <p>
     * One or more vulnerabilities that are related to the vulnerability being described.
     * </p>
     */
    private java.util.List<String> relatedVulnerabilities;

    /**
     * <p>
     * An object that describes the location of the detected security vulnerability in your code.
     * </p>
     * 
     * @param filePath
     *        An object that describes the location of the detected security vulnerability in your code.
     */

    public void setFilePath(FilePath filePath) {
        this.filePath = filePath;
    }

    /**
     * <p>
     * An object that describes the location of the detected security vulnerability in your code.
     * </p>
     * 
     * @return An object that describes the location of the detected security vulnerability in your code.
     */

    public FilePath getFilePath() {
        return this.filePath;
    }

    /**
     * <p>
     * An object that describes the location of the detected security vulnerability in your code.
     * </p>
     * 
     * @param filePath
     *        An object that describes the location of the detected security vulnerability in your code.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withFilePath(FilePath filePath) {
        setFilePath(filePath);
        return this;
    }

    /**
     * <p>
     * The identifier for the vulnerability.
     * </p>
     * 
     * @param id
     *        The identifier for the vulnerability.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * The identifier for the vulnerability.
     * </p>
     * 
     * @return The identifier for the vulnerability.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * The identifier for the vulnerability.
     * </p>
     * 
     * @param id
     *        The identifier for the vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * The number of times the vulnerability appears in your code.
     * </p>
     * 
     * @param itemCount
     *        The number of times the vulnerability appears in your code.
     */
    @Deprecated
    public void setItemCount(Integer itemCount) {
        this.itemCount = itemCount;
    }

    /**
     * <p>
     * The number of times the vulnerability appears in your code.
     * </p>
     * 
     * @return The number of times the vulnerability appears in your code.
     */
    @Deprecated
    public Integer getItemCount() {
        return this.itemCount;
    }

    /**
     * <p>
     * The number of times the vulnerability appears in your code.
     * </p>
     * 
     * @param itemCount
     *        The number of times the vulnerability appears in your code.
     * @return Returns a reference to this object so that method calls can be chained together.
     */
    @Deprecated
    public Vulnerability withItemCount(Integer itemCount) {
        setItemCount(itemCount);
        return this;
    }

    /**
     * <p>
     * One or more URL addresses that contain details about a vulnerability.
     * </p>
     * 
     * @return One or more URL addresses that contain details about a vulnerability.
     */

    public java.util.List<String> getReferenceUrls() {
        return referenceUrls;
    }

    /**
     * <p>
     * One or more URL addresses that contain details about a vulnerability.
     * </p>
     * 
     * @param referenceUrls
     *        One or more URL addresses that contain details about a vulnerability.
     */

    public void setReferenceUrls(java.util.Collection<String> referenceUrls) {
        if (referenceUrls == null) {
            this.referenceUrls = null;
            return;
        }

        this.referenceUrls = new java.util.ArrayList<String>(referenceUrls);
    }

    /**
     * <p>
     * One or more URL addresses that contain details about a vulnerability.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setReferenceUrls(java.util.Collection)} or {@link #withReferenceUrls(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param referenceUrls
     *        One or more URL addresses that contain details about a vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withReferenceUrls(String... referenceUrls) {
        if (this.referenceUrls == null) {
            setReferenceUrls(new java.util.ArrayList<String>(referenceUrls.length));
        }
        for (String ele : referenceUrls) {
            this.referenceUrls.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * One or more URL addresses that contain details about a vulnerability.
     * </p>
     * 
     * @param referenceUrls
     *        One or more URL addresses that contain details about a vulnerability.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withReferenceUrls(java.util.Collection<String> referenceUrls) {
        setReferenceUrls(referenceUrls);
        return this;
    }

    /**
     * <p>
     * One or more vulnerabilities that are related to the vulnerability being described.
     * </p>
     * 
     * @return One or more vulnerabilities that are related to the vulnerability being described.
     */

    public java.util.List<String> getRelatedVulnerabilities() {
        return relatedVulnerabilities;
    }

    /**
     * <p>
     * One or more vulnerabilities that are related to the vulnerability being described.
     * </p>
     * 
     * @param relatedVulnerabilities
     *        One or more vulnerabilities that are related to the vulnerability being described.
     */

    public void setRelatedVulnerabilities(java.util.Collection<String> relatedVulnerabilities) {
        if (relatedVulnerabilities == null) {
            this.relatedVulnerabilities = null;
            return;
        }

        this.relatedVulnerabilities = new java.util.ArrayList<String>(relatedVulnerabilities);
    }

    /**
     * <p>
     * One or more vulnerabilities that are related to the vulnerability being described.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setRelatedVulnerabilities(java.util.Collection)} or
     * {@link #withRelatedVulnerabilities(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param relatedVulnerabilities
     *        One or more vulnerabilities that are related to the vulnerability being described.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withRelatedVulnerabilities(String... relatedVulnerabilities) {
        if (this.relatedVulnerabilities == null) {
            setRelatedVulnerabilities(new java.util.ArrayList<String>(relatedVulnerabilities.length));
        }
        for (String ele : relatedVulnerabilities) {
            this.relatedVulnerabilities.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * One or more vulnerabilities that are related to the vulnerability being described.
     * </p>
     * 
     * @param relatedVulnerabilities
     *        One or more vulnerabilities that are related to the vulnerability being described.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Vulnerability withRelatedVulnerabilities(java.util.Collection<String> relatedVulnerabilities) {
        setRelatedVulnerabilities(relatedVulnerabilities);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getFilePath() != null)
            sb.append("FilePath: ").append(getFilePath()).append(",");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getItemCount() != null)
            sb.append("ItemCount: ").append(getItemCount()).append(",");
        if (getReferenceUrls() != null)
            sb.append("ReferenceUrls: ").append(getReferenceUrls()).append(",");
        if (getRelatedVulnerabilities() != null)
            sb.append("RelatedVulnerabilities: ").append(getRelatedVulnerabilities());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Vulnerability == false)
            return false;
        Vulnerability other = (Vulnerability) obj;
        if (other.getFilePath() == null ^ this.getFilePath() == null)
            return false;
        if (other.getFilePath() != null && other.getFilePath().equals(this.getFilePath()) == false)
            return false;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getItemCount() == null ^ this.getItemCount() == null)
            return false;
        if (other.getItemCount() != null && other.getItemCount().equals(this.getItemCount()) == false)
            return false;
        if (other.getReferenceUrls() == null ^ this.getReferenceUrls() == null)
            return false;
        if (other.getReferenceUrls() != null && other.getReferenceUrls().equals(this.getReferenceUrls()) == false)
            return false;
        if (other.getRelatedVulnerabilities() == null ^ this.getRelatedVulnerabilities() == null)
            return false;
        if (other.getRelatedVulnerabilities() != null && other.getRelatedVulnerabilities().equals(this.getRelatedVulnerabilities()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getFilePath() == null) ? 0 : getFilePath().hashCode());
        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getItemCount() == null) ? 0 : getItemCount().hashCode());
        hashCode = prime * hashCode + ((getReferenceUrls() == null) ? 0 : getReferenceUrls().hashCode());
        hashCode = prime * hashCode + ((getRelatedVulnerabilities() == null) ? 0 : getRelatedVulnerabilities().hashCode());
        return hashCode;
    }

    @Override
    public Vulnerability clone() {
        try {
            return (Vulnerability) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.codegurusecurity.model.transform.VulnerabilityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
