/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurusecurity;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.codegurusecurity.AmazonCodeGuruSecurityAsync;
import com.amazonaws.services.codegurusecurity.AmazonCodeGuruSecurityAsyncClientBuilder;
import com.amazonaws.services.codegurusecurity.AmazonCodeGuruSecurityClient;
import com.amazonaws.services.codegurusecurity.model.BatchGetFindingsRequest;
import com.amazonaws.services.codegurusecurity.model.BatchGetFindingsResult;
import com.amazonaws.services.codegurusecurity.model.CreateScanRequest;
import com.amazonaws.services.codegurusecurity.model.CreateScanResult;
import com.amazonaws.services.codegurusecurity.model.CreateUploadUrlRequest;
import com.amazonaws.services.codegurusecurity.model.CreateUploadUrlResult;
import com.amazonaws.services.codegurusecurity.model.GetAccountConfigurationRequest;
import com.amazonaws.services.codegurusecurity.model.GetAccountConfigurationResult;
import com.amazonaws.services.codegurusecurity.model.GetFindingsRequest;
import com.amazonaws.services.codegurusecurity.model.GetFindingsResult;
import com.amazonaws.services.codegurusecurity.model.GetMetricsSummaryRequest;
import com.amazonaws.services.codegurusecurity.model.GetMetricsSummaryResult;
import com.amazonaws.services.codegurusecurity.model.GetScanRequest;
import com.amazonaws.services.codegurusecurity.model.GetScanResult;
import com.amazonaws.services.codegurusecurity.model.ListFindingsMetricsRequest;
import com.amazonaws.services.codegurusecurity.model.ListFindingsMetricsResult;
import com.amazonaws.services.codegurusecurity.model.ListScansRequest;
import com.amazonaws.services.codegurusecurity.model.ListScansResult;
import com.amazonaws.services.codegurusecurity.model.ListTagsForResourceRequest;
import com.amazonaws.services.codegurusecurity.model.ListTagsForResourceResult;
import com.amazonaws.services.codegurusecurity.model.TagResourceRequest;
import com.amazonaws.services.codegurusecurity.model.TagResourceResult;
import com.amazonaws.services.codegurusecurity.model.UntagResourceRequest;
import com.amazonaws.services.codegurusecurity.model.UntagResourceResult;
import com.amazonaws.services.codegurusecurity.model.UpdateAccountConfigurationRequest;
import com.amazonaws.services.codegurusecurity.model.UpdateAccountConfigurationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCodeGuruSecurityAsyncClient
extends AmazonCodeGuruSecurityClient
implements AmazonCodeGuruSecurityAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonCodeGuruSecurityAsyncClientBuilder asyncBuilder() {
        return AmazonCodeGuruSecurityAsyncClientBuilder.standard();
    }

    AmazonCodeGuruSecurityAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonCodeGuruSecurityAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchGetFindingsResult> batchGetFindingsAsync(BatchGetFindingsRequest request) {
        return this.batchGetFindingsAsync(request, null);
    }

    @Override
    public Future<BatchGetFindingsResult> batchGetFindingsAsync(BatchGetFindingsRequest request, final AsyncHandler<BatchGetFindingsRequest, BatchGetFindingsResult> asyncHandler) {
        final BatchGetFindingsRequest finalRequest = (BatchGetFindingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetFindingsResult>(){

            @Override
            public BatchGetFindingsResult call() throws Exception {
                BatchGetFindingsResult result = null;
                try {
                    result = AmazonCodeGuruSecurityAsyncClient.this.executeBatchGetFindings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateScanResult> createScanAsync(CreateScanRequest request) {
        return this.createScanAsync(request, null);
    }

    @Override
    public Future<CreateScanResult> createScanAsync(CreateScanRequest request, final AsyncHandler<CreateScanRequest, CreateScanResult> asyncHandler) {
        final CreateScanRequest finalRequest = (CreateScanRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateScanResult>(){

            @Override
            public CreateScanResult call() throws Exception {
                CreateScanResult result = null;
                try {
                    result = AmazonCodeGuruSecurityAsyncClient.this.executeCreateScan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateUploadUrlResult> createUploadUrlAsync(CreateUploadUrlRequest request) {
        return this.createUploadUrlAsync(request, null);
    }

    @Override
    public Future<CreateUploadUrlResult> createUploadUrlAsync(CreateUploadUrlRequest request, final AsyncHandler<CreateUploadUrlRequest, CreateUploadUrlResult> asyncHandler) {
        final CreateUploadUrlRequest finalRequest = (CreateUploadUrlRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateUploadUrlResult>(){

            @Override
            public CreateUploadUrlResult call() throws Exception {
                CreateUploadUrlResult result = null;
                try {
                    result = AmazonCodeGuruSecurityAsyncClient.this.executeCreateUploadUrl(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAccountConfigurationResult> getAccountConfigurationAsync(GetAccountConfigurationRequest request) {
        return this.getAccountConfigurationAsync(request, null);
    }

    @Override
    public Future<GetAccountConfigurationResult> getAccountConfigurationAsync(GetAccountConfigurationRequest request, final AsyncHandler<GetAccountConfigurationRequest, GetAccountConfigurationResult> asyncHandler) {
        final GetAccountConfigurationRequest finalRequest = (GetAccountConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAccountConfigurationResult>(){

            @Override
            public GetAccountConfigurationResult call() throws Exception {
                GetAccountConfigurationResult result = null;
                try {
                    result = AmazonCodeGuruSecurityAsyncClient.this.executeGetAccountConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFindingsResult> getFindingsAsync(GetFindingsRequest request) {
        return this.getFindingsAsync(request, null);
    }

    @Override
    public Future<GetFindingsResult> getFindingsAsync(GetFindingsRequest request, final AsyncHandler<GetFindingsRequest, GetFindingsResult> asyncHandler) {
        final GetFindingsRequest finalRequest = (GetFindingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFindingsResult>(){

            @Override
            public GetFindingsResult call() throws Exception {
                GetFindingsResult result = null;
                try {
                    result = AmazonCodeGuruSecurityAsyncClient.this.executeGetFindings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMetricsSummaryResult> getMetricsSummaryAsync(GetMetricsSummaryRequest request) {
        return this.getMetricsSummaryAsync(request, null);
    }

    @Override
    public Future<GetMetricsSummaryResult> getMetricsSummaryAsync(GetMetricsSummaryRequest request, final AsyncHandler<GetMetricsSummaryRequest, GetMetricsSummaryResult> asyncHandler) {
        final GetMetricsSummaryRequest finalRequest = (GetMetricsSummaryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMetricsSummaryResult>(){

            @Override
            public GetMetricsSummaryResult call() throws Exception {
                GetMetricsSummaryResult result = null;
                try {
                    result = AmazonCodeGuruSecurityAsyncClient.this.executeGetMetricsSummary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetScanResult> getScanAsync(GetScanRequest request) {
        return this.getScanAsync(request, null);
    }

    @Override
    public Future<GetScanResult> getScanAsync(GetScanRequest request, final AsyncHandler<GetScanRequest, GetScanResult> asyncHandler) {
        final GetScanRequest finalRequest = (GetScanRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetScanResult>(){

            @Override
            public GetScanResult call() throws Exception {
                GetScanResult result = null;
                try {
                    result = AmazonCodeGuruSecurityAsyncClient.this.executeGetScan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListFindingsMetricsResult> listFindingsMetricsAsync(ListFindingsMetricsRequest request) {
        return this.listFindingsMetricsAsync(request, null);
    }

    @Override
    public Future<ListFindingsMetricsResult> listFindingsMetricsAsync(ListFindingsMetricsRequest request, final AsyncHandler<ListFindingsMetricsRequest, ListFindingsMetricsResult> asyncHandler) {
        final ListFindingsMetricsRequest finalRequest = (ListFindingsMetricsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListFindingsMetricsResult>(){

            @Override
            public ListFindingsMetricsResult call() throws Exception {
                ListFindingsMetricsResult result = null;
                try {
                    result = AmazonCodeGuruSecurityAsyncClient.this.executeListFindingsMetrics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListScansResult> listScansAsync(ListScansRequest request) {
        return this.listScansAsync(request, null);
    }

    @Override
    public Future<ListScansResult> listScansAsync(ListScansRequest request, final AsyncHandler<ListScansRequest, ListScansResult> asyncHandler) {
        final ListScansRequest finalRequest = (ListScansRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListScansResult>(){

            @Override
            public ListScansResult call() throws Exception {
                ListScansResult result = null;
                try {
                    result = AmazonCodeGuruSecurityAsyncClient.this.executeListScans(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonCodeGuruSecurityAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonCodeGuruSecurityAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonCodeGuruSecurityAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAccountConfigurationResult> updateAccountConfigurationAsync(UpdateAccountConfigurationRequest request) {
        return this.updateAccountConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateAccountConfigurationResult> updateAccountConfigurationAsync(UpdateAccountConfigurationRequest request, final AsyncHandler<UpdateAccountConfigurationRequest, UpdateAccountConfigurationResult> asyncHandler) {
        final UpdateAccountConfigurationRequest finalRequest = (UpdateAccountConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAccountConfigurationResult>(){

            @Override
            public UpdateAccountConfigurationResult call() throws Exception {
                UpdateAccountConfigurationResult result = null;
                try {
                    result = AmazonCodeGuruSecurityAsyncClient.this.executeUpdateAccountConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

