/*
 * Copyright 2010-2016 Amazon.com, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.codepipeline.model;

import java.io.Serializable;

/**
 * <p>
 * Represents the output of a list action types action.
 * </p>
 */
public class ListActionTypesResult implements Serializable, Cloneable {

    /**
     * <p>
     * Provides details of the action types.
     * </p>
     */
    private java.util.List<ActionType> actionTypes;
    /**
     * <p>
     * If the amount of returned information is significantly large, an
     * identifier is also returned which can be used in a subsequent list action
     * types call to return the next set of action types in the list.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * Provides details of the action types.
     * </p>
     * 
     * @return Provides details of the action types.
     */
    public java.util.List<ActionType> getActionTypes() {
        return actionTypes;
    }

    /**
     * <p>
     * Provides details of the action types.
     * </p>
     * 
     * @param actionTypes
     *        Provides details of the action types.
     */
    public void setActionTypes(java.util.Collection<ActionType> actionTypes) {
        if (actionTypes == null) {
            this.actionTypes = null;
            return;
        }

        this.actionTypes = new java.util.ArrayList<ActionType>(actionTypes);
    }

    /**
     * <p>
     * Provides details of the action types.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if
     * any). Use {@link #setActionTypes(java.util.Collection)} or
     * {@link #withActionTypes(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param actionTypes
     *        Provides details of the action types.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public ListActionTypesResult withActionTypes(ActionType... actionTypes) {
        if (this.actionTypes == null) {
            setActionTypes(new java.util.ArrayList<ActionType>(
                    actionTypes.length));
        }
        for (ActionType ele : actionTypes) {
            this.actionTypes.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Provides details of the action types.
     * </p>
     * 
     * @param actionTypes
     *        Provides details of the action types.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public ListActionTypesResult withActionTypes(
            java.util.Collection<ActionType> actionTypes) {
        setActionTypes(actionTypes);
        return this;
    }

    /**
     * <p>
     * If the amount of returned information is significantly large, an
     * identifier is also returned which can be used in a subsequent list action
     * types call to return the next set of action types in the list.
     * </p>
     * 
     * @param nextToken
     *        If the amount of returned information is significantly large, an
     *        identifier is also returned which can be used in a subsequent list
     *        action types call to return the next set of action types in the
     *        list.
     */
    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * If the amount of returned information is significantly large, an
     * identifier is also returned which can be used in a subsequent list action
     * types call to return the next set of action types in the list.
     * </p>
     * 
     * @return If the amount of returned information is significantly large, an
     *         identifier is also returned which can be used in a subsequent
     *         list action types call to return the next set of action types in
     *         the list.
     */
    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * If the amount of returned information is significantly large, an
     * identifier is also returned which can be used in a subsequent list action
     * types call to return the next set of action types in the list.
     * </p>
     * 
     * @param nextToken
     *        If the amount of returned information is significantly large, an
     *        identifier is also returned which can be used in a subsequent list
     *        action types call to return the next set of action types in the
     *        list.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public ListActionTypesResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getActionTypes() != null)
            sb.append("ActionTypes: " + getActionTypes() + ",");
        if (getNextToken() != null)
            sb.append("NextToken: " + getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListActionTypesResult == false)
            return false;
        ListActionTypesResult other = (ListActionTypesResult) obj;
        if (other.getActionTypes() == null ^ this.getActionTypes() == null)
            return false;
        if (other.getActionTypes() != null
                && other.getActionTypes().equals(this.getActionTypes()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null
                && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime
                * hashCode
                + ((getActionTypes() == null) ? 0 : getActionTypes().hashCode());
        hashCode = prime * hashCode
                + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListActionTypesResult clone() {
        try {
            return (ListActionTypesResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException(
                    "Got a CloneNotSupportedException from Object.clone() "
                            + "even though we're Cloneable!", e);
        }
    }
}