/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codepipeline.model.ActionConfigurationProperty;
import com.amazonaws.services.codepipeline.model.ActionType;
import com.amazonaws.services.codepipeline.model.transform.ActionConfigurationPropertyJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ActionTypeIdJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ActionTypeSettingsJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ArtifactDetailsJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.List;

public class ActionTypeJsonMarshaller {
    private static ActionTypeJsonMarshaller instance;

    public void marshall(ActionType actionType, SdkJsonGenerator jsonGenerator) {
        if (actionType == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ActionConfigurationProperty> actionConfigurationPropertiesList;
            jsonGenerator.writeStartObject();
            if (actionType.getId() != null) {
                jsonGenerator.writeFieldName("id");
                ActionTypeIdJsonMarshaller.getInstance().marshall(actionType.getId(), jsonGenerator);
            }
            if (actionType.getSettings() != null) {
                jsonGenerator.writeFieldName("settings");
                ActionTypeSettingsJsonMarshaller.getInstance().marshall(actionType.getSettings(), jsonGenerator);
            }
            if ((actionConfigurationPropertiesList = actionType.getActionConfigurationProperties()) != null) {
                jsonGenerator.writeFieldName("actionConfigurationProperties");
                jsonGenerator.writeStartArray();
                for (ActionConfigurationProperty actionConfigurationPropertiesListValue : actionConfigurationPropertiesList) {
                    if (actionConfigurationPropertiesListValue == null) continue;
                    ActionConfigurationPropertyJsonMarshaller.getInstance().marshall(actionConfigurationPropertiesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (actionType.getInputArtifactDetails() != null) {
                jsonGenerator.writeFieldName("inputArtifactDetails");
                ArtifactDetailsJsonMarshaller.getInstance().marshall(actionType.getInputArtifactDetails(), jsonGenerator);
            }
            if (actionType.getOutputArtifactDetails() != null) {
                jsonGenerator.writeFieldName("outputArtifactDetails");
                ArtifactDetailsJsonMarshaller.getInstance().marshall(actionType.getOutputArtifactDetails(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ActionTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ActionTypeJsonMarshaller();
        }
        return instance;
    }
}

