/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codepipeline.model.Job;
import com.amazonaws.services.codepipeline.model.transform.JobDataJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class JobJsonMarshaller {
    private static JobJsonMarshaller instance;

    public void marshall(Job job, SdkJsonGenerator jsonGenerator) {
        if (job == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (job.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(job.getId());
            }
            if (job.getData() != null) {
                jsonGenerator.writeFieldName("data");
                JobDataJsonMarshaller.getInstance().marshall(job.getData(), jsonGenerator);
            }
            if (job.getNonce() != null) {
                jsonGenerator.writeFieldName("nonce").writeValue(job.getNonce());
            }
            if (job.getAccountId() != null) {
                jsonGenerator.writeFieldName("accountId").writeValue(job.getAccountId());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobJsonMarshaller();
        }
        return instance;
    }
}

