/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codepipeline.model.Artifact;
import com.amazonaws.services.codepipeline.model.ThirdPartyJobData;
import com.amazonaws.services.codepipeline.model.transform.AWSSessionCredentialsJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ActionConfigurationJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ActionTypeIdJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ArtifactJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.EncryptionKeyJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.PipelineContextJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.List;

public class ThirdPartyJobDataJsonMarshaller {
    private static ThirdPartyJobDataJsonMarshaller instance;

    public void marshall(ThirdPartyJobData thirdPartyJobData, SdkJsonGenerator jsonGenerator) {
        if (thirdPartyJobData == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Artifact> outputArtifactsList;
            List<Artifact> inputArtifactsList;
            jsonGenerator.writeStartObject();
            if (thirdPartyJobData.getActionTypeId() != null) {
                jsonGenerator.writeFieldName("actionTypeId");
                ActionTypeIdJsonMarshaller.getInstance().marshall(thirdPartyJobData.getActionTypeId(), jsonGenerator);
            }
            if (thirdPartyJobData.getActionConfiguration() != null) {
                jsonGenerator.writeFieldName("actionConfiguration");
                ActionConfigurationJsonMarshaller.getInstance().marshall(thirdPartyJobData.getActionConfiguration(), jsonGenerator);
            }
            if (thirdPartyJobData.getPipelineContext() != null) {
                jsonGenerator.writeFieldName("pipelineContext");
                PipelineContextJsonMarshaller.getInstance().marshall(thirdPartyJobData.getPipelineContext(), jsonGenerator);
            }
            if ((inputArtifactsList = thirdPartyJobData.getInputArtifacts()) != null) {
                jsonGenerator.writeFieldName("inputArtifacts");
                jsonGenerator.writeStartArray();
                for (Artifact inputArtifactsListValue : inputArtifactsList) {
                    if (inputArtifactsListValue == null) continue;
                    ArtifactJsonMarshaller.getInstance().marshall(inputArtifactsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((outputArtifactsList = thirdPartyJobData.getOutputArtifacts()) != null) {
                jsonGenerator.writeFieldName("outputArtifacts");
                jsonGenerator.writeStartArray();
                for (Artifact outputArtifactsListValue : outputArtifactsList) {
                    if (outputArtifactsListValue == null) continue;
                    ArtifactJsonMarshaller.getInstance().marshall(outputArtifactsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (thirdPartyJobData.getArtifactCredentials() != null) {
                jsonGenerator.writeFieldName("artifactCredentials");
                AWSSessionCredentialsJsonMarshaller.getInstance().marshall(thirdPartyJobData.getArtifactCredentials(), jsonGenerator);
            }
            if (thirdPartyJobData.getContinuationToken() != null) {
                jsonGenerator.writeFieldName("continuationToken").writeValue(thirdPartyJobData.getContinuationToken());
            }
            if (thirdPartyJobData.getEncryptionKey() != null) {
                jsonGenerator.writeFieldName("encryptionKey");
                EncryptionKeyJsonMarshaller.getInstance().marshall(thirdPartyJobData.getEncryptionKey(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ThirdPartyJobDataJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ThirdPartyJobDataJsonMarshaller();
        }
        return instance;
    }
}

