/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.ActionDeclaration;
import com.amazonaws.services.codepipeline.model.InputArtifact;
import com.amazonaws.services.codepipeline.model.OutputArtifact;
import com.amazonaws.services.codepipeline.model.transform.ActionTypeIdJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.InputArtifactJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.OutputArtifactJsonMarshaller;
import java.util.List;
import java.util.Map;

public class ActionDeclarationJsonMarshaller {
    private static ActionDeclarationJsonMarshaller instance;

    public void marshall(ActionDeclaration actionDeclaration, StructuredJsonGenerator jsonGenerator) {
        if (actionDeclaration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<InputArtifact> inputArtifactsList;
            List<OutputArtifact> outputArtifactsList;
            Map<String, String> configurationMap;
            jsonGenerator.writeStartObject();
            if (actionDeclaration.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(actionDeclaration.getName());
            }
            if (actionDeclaration.getActionTypeId() != null) {
                jsonGenerator.writeFieldName("actionTypeId");
                ActionTypeIdJsonMarshaller.getInstance().marshall(actionDeclaration.getActionTypeId(), jsonGenerator);
            }
            if (actionDeclaration.getRunOrder() != null) {
                jsonGenerator.writeFieldName("runOrder").writeValue(actionDeclaration.getRunOrder().intValue());
            }
            if ((configurationMap = actionDeclaration.getConfiguration()) != null) {
                jsonGenerator.writeFieldName("configuration");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> configurationMapValue : configurationMap.entrySet()) {
                    if (configurationMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)configurationMapValue.getKey());
                    jsonGenerator.writeValue((String)configurationMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((outputArtifactsList = actionDeclaration.getOutputArtifacts()) != null) {
                jsonGenerator.writeFieldName("outputArtifacts");
                jsonGenerator.writeStartArray();
                for (OutputArtifact outputArtifactsListValue : outputArtifactsList) {
                    if (outputArtifactsListValue == null) continue;
                    OutputArtifactJsonMarshaller.getInstance().marshall(outputArtifactsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((inputArtifactsList = actionDeclaration.getInputArtifacts()) != null) {
                jsonGenerator.writeFieldName("inputArtifacts");
                jsonGenerator.writeStartArray();
                for (InputArtifact inputArtifactsListValue : inputArtifactsList) {
                    if (inputArtifactsListValue == null) continue;
                    InputArtifactJsonMarshaller.getInstance().marshall(inputArtifactsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (actionDeclaration.getRoleArn() != null) {
                jsonGenerator.writeFieldName("roleArn").writeValue(actionDeclaration.getRoleArn());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ActionDeclarationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ActionDeclarationJsonMarshaller();
        }
        return instance;
    }
}

