/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.DeleteCustomActionTypeRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteCustomActionTypeRequestMarshaller
implements Marshaller<Request<DeleteCustomActionTypeRequest>, DeleteCustomActionTypeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteCustomActionTypeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeleteCustomActionTypeRequest> marshall(DeleteCustomActionTypeRequest deleteCustomActionTypeRequest) {
        if (deleteCustomActionTypeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteCustomActionTypeRequest, "AWSCodePipeline");
        request.addHeader("X-Amz-Target", "CodePipeline_20150709.DeleteCustomActionType");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteCustomActionTypeRequest.getCategory() != null) {
                jsonGenerator.writeFieldName("category").writeValue(deleteCustomActionTypeRequest.getCategory());
            }
            if (deleteCustomActionTypeRequest.getProvider() != null) {
                jsonGenerator.writeFieldName("provider").writeValue(deleteCustomActionTypeRequest.getProvider());
            }
            if (deleteCustomActionTypeRequest.getVersion() != null) {
                jsonGenerator.writeFieldName("version").writeValue(deleteCustomActionTypeRequest.getVersion());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

