/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.EnableStageTransitionRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class EnableStageTransitionRequestMarshaller
implements Marshaller<Request<EnableStageTransitionRequest>, EnableStageTransitionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public EnableStageTransitionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<EnableStageTransitionRequest> marshall(EnableStageTransitionRequest enableStageTransitionRequest) {
        if (enableStageTransitionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)enableStageTransitionRequest, "AWSCodePipeline");
        request.addHeader("X-Amz-Target", "CodePipeline_20150709.EnableStageTransition");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (enableStageTransitionRequest.getPipelineName() != null) {
                jsonGenerator.writeFieldName("pipelineName").writeValue(enableStageTransitionRequest.getPipelineName());
            }
            if (enableStageTransitionRequest.getStageName() != null) {
                jsonGenerator.writeFieldName("stageName").writeValue(enableStageTransitionRequest.getStageName());
            }
            if (enableStageTransitionRequest.getTransitionType() != null) {
                jsonGenerator.writeFieldName("transitionType").writeValue(enableStageTransitionRequest.getTransitionType());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

