/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.Job;
import com.amazonaws.services.codepipeline.model.transform.JobDataJsonMarshaller;

public class JobJsonMarshaller {
    private static JobJsonMarshaller instance;

    public void marshall(Job job, StructuredJsonGenerator jsonGenerator) {
        if (job == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (job.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(job.getId());
            }
            if (job.getData() != null) {
                jsonGenerator.writeFieldName("data");
                JobDataJsonMarshaller.getInstance().marshall(job.getData(), jsonGenerator);
            }
            if (job.getNonce() != null) {
                jsonGenerator.writeFieldName("nonce").writeValue(job.getNonce());
            }
            if (job.getAccountId() != null) {
                jsonGenerator.writeFieldName("accountId").writeValue(job.getAccountId());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobJsonMarshaller();
        }
        return instance;
    }
}

