/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codepipeline.model.ActionTypeId;
import com.amazonaws.services.codepipeline.model.ArtifactDetail;
import com.amazonaws.services.codepipeline.model.transform.ActionExecutionInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionExecutionInput
implements Serializable,
Cloneable,
StructuredPojo {
    private ActionTypeId actionTypeId;
    private Map<String, String> configuration;
    private String roleArn;
    private String region;
    private List<ArtifactDetail> inputArtifacts;

    public void setActionTypeId(ActionTypeId actionTypeId) {
        this.actionTypeId = actionTypeId;
    }

    public ActionTypeId getActionTypeId() {
        return this.actionTypeId;
    }

    public ActionExecutionInput withActionTypeId(ActionTypeId actionTypeId) {
        this.setActionTypeId(actionTypeId);
        return this;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public ActionExecutionInput withConfiguration(Map<String, String> configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public ActionExecutionInput addConfigurationEntry(String key, String value) {
        if (null == this.configuration) {
            this.configuration = new HashMap<String, String>();
        }
        if (this.configuration.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.configuration.put(key, value);
        return this;
    }

    public ActionExecutionInput clearConfigurationEntries() {
        this.configuration = null;
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public ActionExecutionInput withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public ActionExecutionInput withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public List<ArtifactDetail> getInputArtifacts() {
        return this.inputArtifacts;
    }

    public void setInputArtifacts(Collection<ArtifactDetail> inputArtifacts) {
        if (inputArtifacts == null) {
            this.inputArtifacts = null;
            return;
        }
        this.inputArtifacts = new ArrayList<ArtifactDetail>(inputArtifacts);
    }

    public ActionExecutionInput withInputArtifacts(ArtifactDetail ... inputArtifacts) {
        if (this.inputArtifacts == null) {
            this.setInputArtifacts(new ArrayList<ArtifactDetail>(inputArtifacts.length));
        }
        for (ArtifactDetail ele : inputArtifacts) {
            this.inputArtifacts.add(ele);
        }
        return this;
    }

    public ActionExecutionInput withInputArtifacts(Collection<ArtifactDetail> inputArtifacts) {
        this.setInputArtifacts(inputArtifacts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActionTypeId() != null) {
            sb.append("ActionTypeId: ").append(this.getActionTypeId()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getRegion() != null) {
            sb.append("Region: ").append(this.getRegion()).append(",");
        }
        if (this.getInputArtifacts() != null) {
            sb.append("InputArtifacts: ").append(this.getInputArtifacts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionExecutionInput)) {
            return false;
        }
        ActionExecutionInput other = (ActionExecutionInput)obj;
        if (other.getActionTypeId() == null ^ this.getActionTypeId() == null) {
            return false;
        }
        if (other.getActionTypeId() != null && !other.getActionTypeId().equals(this.getActionTypeId())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        if (other.getRegion() != null && !other.getRegion().equals(this.getRegion())) {
            return false;
        }
        if (other.getInputArtifacts() == null ^ this.getInputArtifacts() == null) {
            return false;
        }
        return other.getInputArtifacts() == null || other.getInputArtifacts().equals(this.getInputArtifacts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActionTypeId() == null ? 0 : this.getActionTypeId().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        hashCode = 31 * hashCode + (this.getInputArtifacts() == null ? 0 : this.getInputArtifacts().hashCode());
        return hashCode;
    }

    public ActionExecutionInput clone() {
        try {
            return (ActionExecutionInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionExecutionInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

