/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.PutJobFailureResultRequest;
import com.amazonaws.services.codepipeline.model.transform.FailureDetailsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PutJobFailureResultRequestMarshaller
implements Marshaller<Request<PutJobFailureResultRequest>, PutJobFailureResultRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PutJobFailureResultRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutJobFailureResultRequest> marshall(PutJobFailureResultRequest putJobFailureResultRequest) {
        if (putJobFailureResultRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putJobFailureResultRequest, "AWSCodePipeline");
        request.addHeader("X-Amz-Target", "CodePipeline_20150709.PutJobFailureResult");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putJobFailureResultRequest.getJobId() != null) {
                jsonGenerator.writeFieldName("jobId").writeValue(putJobFailureResultRequest.getJobId());
            }
            if (putJobFailureResultRequest.getFailureDetails() != null) {
                jsonGenerator.writeFieldName("failureDetails");
                FailureDetailsJsonMarshaller.getInstance().marshall(putJobFailureResultRequest.getFailureDetails(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

