/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.PipelineDeclaration;
import com.amazonaws.services.codepipeline.model.StageDeclaration;
import com.amazonaws.services.codepipeline.model.transform.ArtifactStoreJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.StageDeclarationJsonMarshaller;
import java.util.List;

public class PipelineDeclarationJsonMarshaller {
    private static PipelineDeclarationJsonMarshaller instance;

    public void marshall(PipelineDeclaration pipelineDeclaration, StructuredJsonGenerator jsonGenerator) {
        if (pipelineDeclaration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<StageDeclaration> stagesList;
            jsonGenerator.writeStartObject();
            if (pipelineDeclaration.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(pipelineDeclaration.getName());
            }
            if (pipelineDeclaration.getRoleArn() != null) {
                jsonGenerator.writeFieldName("roleArn").writeValue(pipelineDeclaration.getRoleArn());
            }
            if (pipelineDeclaration.getArtifactStore() != null) {
                jsonGenerator.writeFieldName("artifactStore");
                ArtifactStoreJsonMarshaller.getInstance().marshall(pipelineDeclaration.getArtifactStore(), jsonGenerator);
            }
            if ((stagesList = pipelineDeclaration.getStages()) != null) {
                jsonGenerator.writeFieldName("stages");
                jsonGenerator.writeStartArray();
                for (StageDeclaration stagesListValue : stagesList) {
                    if (stagesListValue == null) continue;
                    StageDeclarationJsonMarshaller.getInstance().marshall(stagesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (pipelineDeclaration.getVersion() != null) {
                jsonGenerator.writeFieldName("version").writeValue(pipelineDeclaration.getVersion().intValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PipelineDeclarationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PipelineDeclarationJsonMarshaller();
        }
        return instance;
    }
}

