/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.ArtifactStore;
import com.amazonaws.services.codepipeline.model.transform.EncryptionKeyJsonMarshaller;

public class ArtifactStoreJsonMarshaller {
    private static ArtifactStoreJsonMarshaller instance;

    public void marshall(ArtifactStore artifactStore, StructuredJsonGenerator jsonGenerator) {
        if (artifactStore == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (artifactStore.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(artifactStore.getType());
            }
            if (artifactStore.getLocation() != null) {
                jsonGenerator.writeFieldName("location").writeValue(artifactStore.getLocation());
            }
            if (artifactStore.getEncryptionKey() != null) {
                jsonGenerator.writeFieldName("encryptionKey");
                EncryptionKeyJsonMarshaller.getInstance().marshall(artifactStore.getEncryptionKey(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ArtifactStoreJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ArtifactStoreJsonMarshaller();
        }
        return instance;
    }
}

