/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.PollForJobsRequest;
import com.amazonaws.services.codepipeline.model.transform.ActionTypeIdJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class PollForJobsRequestMarshaller
implements Marshaller<Request<PollForJobsRequest>, PollForJobsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public PollForJobsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PollForJobsRequest> marshall(PollForJobsRequest pollForJobsRequest) {
        if (pollForJobsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)pollForJobsRequest, "AWSCodePipeline");
        request.addHeader("X-Amz-Target", "CodePipeline_20150709.PollForJobs");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, String> queryParamMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (pollForJobsRequest.getActionTypeId() != null) {
                jsonGenerator.writeFieldName("actionTypeId");
                ActionTypeIdJsonMarshaller.getInstance().marshall(pollForJobsRequest.getActionTypeId(), jsonGenerator);
            }
            if (pollForJobsRequest.getMaxBatchSize() != null) {
                jsonGenerator.writeFieldName("maxBatchSize").writeValue(pollForJobsRequest.getMaxBatchSize().intValue());
            }
            if ((queryParamMap = pollForJobsRequest.getQueryParam()) != null) {
                jsonGenerator.writeFieldName("queryParam");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> queryParamMapValue : queryParamMap.entrySet()) {
                    if (queryParamMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(queryParamMapValue.getKey());
                    jsonGenerator.writeValue(queryParamMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

