/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codepipeline.model.ArtifactStore;
import com.amazonaws.services.codepipeline.model.StageDeclaration;
import com.amazonaws.services.codepipeline.model.transform.PipelineDeclarationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PipelineDeclaration
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String roleArn;
    private ArtifactStore artifactStore;
    private Map<String, ArtifactStore> artifactStores;
    private List<StageDeclaration> stages;
    private Integer version;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PipelineDeclaration withName(String name) {
        this.setName(name);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public PipelineDeclaration withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setArtifactStore(ArtifactStore artifactStore) {
        this.artifactStore = artifactStore;
    }

    public ArtifactStore getArtifactStore() {
        return this.artifactStore;
    }

    public PipelineDeclaration withArtifactStore(ArtifactStore artifactStore) {
        this.setArtifactStore(artifactStore);
        return this;
    }

    public Map<String, ArtifactStore> getArtifactStores() {
        return this.artifactStores;
    }

    public void setArtifactStores(Map<String, ArtifactStore> artifactStores) {
        this.artifactStores = artifactStores;
    }

    public PipelineDeclaration withArtifactStores(Map<String, ArtifactStore> artifactStores) {
        this.setArtifactStores(artifactStores);
        return this;
    }

    public PipelineDeclaration addArtifactStoresEntry(String key, ArtifactStore value) {
        if (null == this.artifactStores) {
            this.artifactStores = new HashMap<String, ArtifactStore>();
        }
        if (this.artifactStores.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.artifactStores.put(key, value);
        return this;
    }

    public PipelineDeclaration clearArtifactStoresEntries() {
        this.artifactStores = null;
        return this;
    }

    public List<StageDeclaration> getStages() {
        return this.stages;
    }

    public void setStages(Collection<StageDeclaration> stages) {
        if (stages == null) {
            this.stages = null;
            return;
        }
        this.stages = new ArrayList<StageDeclaration>(stages);
    }

    public PipelineDeclaration withStages(StageDeclaration ... stages) {
        if (this.stages == null) {
            this.setStages(new ArrayList<StageDeclaration>(stages.length));
        }
        for (StageDeclaration ele : stages) {
            this.stages.add(ele);
        }
        return this;
    }

    public PipelineDeclaration withStages(Collection<StageDeclaration> stages) {
        this.setStages(stages);
        return this;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Integer getVersion() {
        return this.version;
    }

    public PipelineDeclaration withVersion(Integer version) {
        this.setVersion(version);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getArtifactStore() != null) {
            sb.append("ArtifactStore: ").append(this.getArtifactStore()).append(",");
        }
        if (this.getArtifactStores() != null) {
            sb.append("ArtifactStores: ").append(this.getArtifactStores()).append(",");
        }
        if (this.getStages() != null) {
            sb.append("Stages: ").append(this.getStages()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineDeclaration)) {
            return false;
        }
        PipelineDeclaration other = (PipelineDeclaration)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getArtifactStore() == null ^ this.getArtifactStore() == null) {
            return false;
        }
        if (other.getArtifactStore() != null && !other.getArtifactStore().equals(this.getArtifactStore())) {
            return false;
        }
        if (other.getArtifactStores() == null ^ this.getArtifactStores() == null) {
            return false;
        }
        if (other.getArtifactStores() != null && !other.getArtifactStores().equals(this.getArtifactStores())) {
            return false;
        }
        if (other.getStages() == null ^ this.getStages() == null) {
            return false;
        }
        if (other.getStages() != null && !other.getStages().equals(this.getStages())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        return other.getVersion() == null || other.getVersion().equals(this.getVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getArtifactStore() == null ? 0 : this.getArtifactStore().hashCode());
        hashCode = 31 * hashCode + (this.getArtifactStores() == null ? 0 : this.getArtifactStores().hashCode());
        hashCode = 31 * hashCode + (this.getStages() == null ? 0 : this.getStages().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        return hashCode;
    }

    public PipelineDeclaration clone() {
        try {
            return (PipelineDeclaration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineDeclarationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

