/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codepipeline.model.ArtifactLocation;
import com.amazonaws.services.codepipeline.model.transform.ArtifactMarshaller;
import java.io.Serializable;

public class Artifact
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String revision;
    private ArtifactLocation location;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Artifact withName(String name) {
        this.setName(name);
        return this;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getRevision() {
        return this.revision;
    }

    public Artifact withRevision(String revision) {
        this.setRevision(revision);
        return this;
    }

    public void setLocation(ArtifactLocation location) {
        this.location = location;
    }

    public ArtifactLocation getLocation() {
        return this.location;
    }

    public Artifact withLocation(ArtifactLocation location) {
        this.setLocation(location);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getRevision() != null) {
            sb.append("Revision: ").append(this.getRevision()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Artifact)) {
            return false;
        }
        Artifact other = (Artifact)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getRevision() == null ^ this.getRevision() == null) {
            return false;
        }
        if (other.getRevision() != null && !other.getRevision().equals(this.getRevision())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        return other.getLocation() == null || other.getLocation().equals(this.getLocation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getRevision() == null ? 0 : this.getRevision().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        return hashCode;
    }

    public Artifact clone() {
        try {
            return (Artifact)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ArtifactMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

