/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codestarconnections.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.codestarconnections.model.Host;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListHostsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Host> hosts;
    private String nextToken;

    public List<Host> getHosts() {
        return this.hosts;
    }

    public void setHosts(Collection<Host> hosts) {
        if (hosts == null) {
            this.hosts = null;
            return;
        }
        this.hosts = new ArrayList<Host>(hosts);
    }

    public ListHostsResult withHosts(Host ... hosts) {
        if (this.hosts == null) {
            this.setHosts(new ArrayList<Host>(hosts.length));
        }
        for (Host ele : hosts) {
            this.hosts.add(ele);
        }
        return this;
    }

    public ListHostsResult withHosts(Collection<Host> hosts) {
        this.setHosts(hosts);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListHostsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHosts() != null) {
            sb.append("Hosts: ").append(this.getHosts()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostsResult)) {
            return false;
        }
        ListHostsResult other = (ListHostsResult)obj;
        if (other.getHosts() == null ^ this.getHosts() == null) {
            return false;
        }
        if (other.getHosts() != null && !other.getHosts().equals(this.getHosts())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHosts() == null ? 0 : this.getHosts().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListHostsResult clone() {
        try {
            return (ListHostsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

