/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codestarconnections.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codestarconnections.model.RepositorySyncEvent;
import com.amazonaws.services.codestarconnections.model.RepositorySyncStatus;
import com.amazonaws.services.codestarconnections.model.transform.RepositorySyncAttemptMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class RepositorySyncAttempt
implements Serializable,
Cloneable,
StructuredPojo {
    private Date startedAt;
    private String status;
    private List<RepositorySyncEvent> events;

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    public Date getStartedAt() {
        return this.startedAt;
    }

    public RepositorySyncAttempt withStartedAt(Date startedAt) {
        this.setStartedAt(startedAt);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public RepositorySyncAttempt withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public RepositorySyncAttempt withStatus(RepositorySyncStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<RepositorySyncEvent> getEvents() {
        return this.events;
    }

    public void setEvents(Collection<RepositorySyncEvent> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        this.events = new ArrayList<RepositorySyncEvent>(events);
    }

    public RepositorySyncAttempt withEvents(RepositorySyncEvent ... events) {
        if (this.events == null) {
            this.setEvents(new ArrayList<RepositorySyncEvent>(events.length));
        }
        for (RepositorySyncEvent ele : events) {
            this.events.add(ele);
        }
        return this;
    }

    public RepositorySyncAttempt withEvents(Collection<RepositorySyncEvent> events) {
        this.setEvents(events);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStartedAt() != null) {
            sb.append("StartedAt: ").append(this.getStartedAt()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getEvents() != null) {
            sb.append("Events: ").append(this.getEvents());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositorySyncAttempt)) {
            return false;
        }
        RepositorySyncAttempt other = (RepositorySyncAttempt)obj;
        if (other.getStartedAt() == null ^ this.getStartedAt() == null) {
            return false;
        }
        if (other.getStartedAt() != null && !other.getStartedAt().equals(this.getStartedAt())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        return other.getEvents() == null || other.getEvents().equals(this.getEvents());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStartedAt() == null ? 0 : this.getStartedAt().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        return hashCode;
    }

    public RepositorySyncAttempt clone() {
        try {
            return (RepositorySyncAttempt)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RepositorySyncAttemptMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

