/*
 * Copyright 2010-2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.cognitoidentity.model;

import java.io.Serializable;
import com.amazonaws.AmazonWebServiceRequest;

/**
 * Input to the ListIdentityPools action.
 */
public class ListIdentityPoolsRequest extends AmazonWebServiceRequest implements
        Serializable, Cloneable {

    /** The maximum number of identities to return. */
    private Integer maxResults;
    /** A pagination token. */
    private String nextToken;

    /**
     * The maximum number of identities to return.
     * 
     * @param maxResults
     *        The maximum number of identities to return.
     */
    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * The maximum number of identities to return.
     * 
     * @return The maximum number of identities to return.
     */
    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * The maximum number of identities to return.
     * 
     * @param maxResults
     *        The maximum number of identities to return.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public ListIdentityPoolsRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * A pagination token.
     * 
     * @param nextToken
     *        A pagination token.
     */
    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * A pagination token.
     * 
     * @return A pagination token.
     */
    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * A pagination token.
     * 
     * @param nextToken
     *        A pagination token.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public ListIdentityPoolsRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMaxResults() != null)
            sb.append("MaxResults: " + getMaxResults() + ",");
        if (getNextToken() != null)
            sb.append("NextToken: " + getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListIdentityPoolsRequest == false)
            return false;
        ListIdentityPoolsRequest other = (ListIdentityPoolsRequest) obj;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null
                && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null
                && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode
                + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode
                + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListIdentityPoolsRequest clone() {
        return (ListIdentityPoolsRequest) super.clone();
    }
}