/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentity.model.LookupDeveloperIdentityRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class LookupDeveloperIdentityRequestMarshaller
implements Marshaller<Request<LookupDeveloperIdentityRequest>, LookupDeveloperIdentityRequest> {
    public Request<LookupDeveloperIdentityRequest> marshall(LookupDeveloperIdentityRequest lookupDeveloperIdentityRequest) {
        if (lookupDeveloperIdentityRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)lookupDeveloperIdentityRequest, "AmazonCognitoIdentity");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityService.LookupDeveloperIdentity");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (lookupDeveloperIdentityRequest.getIdentityPoolId() != null) {
                jsonWriter.key("IdentityPoolId").value((Object)lookupDeveloperIdentityRequest.getIdentityPoolId());
            }
            if (lookupDeveloperIdentityRequest.getIdentityId() != null) {
                jsonWriter.key("IdentityId").value((Object)lookupDeveloperIdentityRequest.getIdentityId());
            }
            if (lookupDeveloperIdentityRequest.getDeveloperUserIdentifier() != null) {
                jsonWriter.key("DeveloperUserIdentifier").value((Object)lookupDeveloperIdentityRequest.getDeveloperUserIdentifier());
            }
            if (lookupDeveloperIdentityRequest.getMaxResults() != null) {
                jsonWriter.key("MaxResults").value((Object)lookupDeveloperIdentityRequest.getMaxResults());
            }
            if (lookupDeveloperIdentityRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value((Object)lookupDeveloperIdentityRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

