/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.cognitoidentity.model.RoleMapping;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class GetIdentityPoolRolesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String identityPoolId;
    private Map<String, String> roles;
    private Map<String, RoleMapping> roleMappings;

    public void setIdentityPoolId(String identityPoolId) {
        this.identityPoolId = identityPoolId;
    }

    public String getIdentityPoolId() {
        return this.identityPoolId;
    }

    public GetIdentityPoolRolesResult withIdentityPoolId(String identityPoolId) {
        this.setIdentityPoolId(identityPoolId);
        return this;
    }

    public Map<String, String> getRoles() {
        return this.roles;
    }

    public void setRoles(Map<String, String> roles) {
        this.roles = roles;
    }

    public GetIdentityPoolRolesResult withRoles(Map<String, String> roles) {
        this.setRoles(roles);
        return this;
    }

    public GetIdentityPoolRolesResult addRolesEntry(String key, String value) {
        if (null == this.roles) {
            this.roles = new HashMap<String, String>();
        }
        if (this.roles.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.roles.put(key, value);
        return this;
    }

    public GetIdentityPoolRolesResult clearRolesEntries() {
        this.roles = null;
        return this;
    }

    public Map<String, RoleMapping> getRoleMappings() {
        return this.roleMappings;
    }

    public void setRoleMappings(Map<String, RoleMapping> roleMappings) {
        this.roleMappings = roleMappings;
    }

    public GetIdentityPoolRolesResult withRoleMappings(Map<String, RoleMapping> roleMappings) {
        this.setRoleMappings(roleMappings);
        return this;
    }

    public GetIdentityPoolRolesResult addRoleMappingsEntry(String key, RoleMapping value) {
        if (null == this.roleMappings) {
            this.roleMappings = new HashMap<String, RoleMapping>();
        }
        if (this.roleMappings.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.roleMappings.put(key, value);
        return this;
    }

    public GetIdentityPoolRolesResult clearRoleMappingsEntries() {
        this.roleMappings = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.getIdentityPoolId()).append(",");
        }
        if (this.getRoles() != null) {
            sb.append("Roles: ").append(this.getRoles()).append(",");
        }
        if (this.getRoleMappings() != null) {
            sb.append("RoleMappings: ").append(this.getRoleMappings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityPoolRolesResult)) {
            return false;
        }
        GetIdentityPoolRolesResult other = (GetIdentityPoolRolesResult)obj;
        if (other.getIdentityPoolId() == null ^ this.getIdentityPoolId() == null) {
            return false;
        }
        if (other.getIdentityPoolId() != null && !other.getIdentityPoolId().equals(this.getIdentityPoolId())) {
            return false;
        }
        if (other.getRoles() == null ^ this.getRoles() == null) {
            return false;
        }
        if (other.getRoles() != null && !other.getRoles().equals(this.getRoles())) {
            return false;
        }
        if (other.getRoleMappings() == null ^ this.getRoleMappings() == null) {
            return false;
        }
        return other.getRoleMappings() == null || other.getRoleMappings().equals(this.getRoleMappings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentityPoolId() == null ? 0 : this.getIdentityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getRoles() == null ? 0 : this.getRoles().hashCode());
        hashCode = 31 * hashCode + (this.getRoleMappings() == null ? 0 : this.getRoleMappings().hashCode());
        return hashCode;
    }

    public GetIdentityPoolRolesResult clone() {
        try {
            return (GetIdentityPoolRolesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

