/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cognitosync.model.ListRecordsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListRecordsRequestMarshaller
implements Marshaller<Request<ListRecordsRequest>, ListRecordsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public ListRecordsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListRecordsRequest> marshall(ListRecordsRequest listRecordsRequest) {
        if (listRecordsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listRecordsRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/records";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", listRecordsRequest.getIdentityPoolId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)listRecordsRequest.getIdentityPoolId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{IdentityId}", listRecordsRequest.getIdentityId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)listRecordsRequest.getIdentityId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{DatasetName}", listRecordsRequest.getDatasetName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)listRecordsRequest.getDatasetName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        if (listRecordsRequest.getLastSyncCount() != null) {
            request.addParameter("lastSyncCount", StringUtils.fromLong((Long)listRecordsRequest.getLastSyncCount()));
        }
        if (listRecordsRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString((String)listRecordsRequest.getNextToken()));
        }
        if (listRecordsRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger((Integer)listRecordsRequest.getMaxResults()));
        }
        if (listRecordsRequest.getSyncSessionToken() != null) {
            request.addParameter("syncSessionToken", StringUtils.fromString((String)listRecordsRequest.getSyncSessionToken()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

