/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.comprehend.model.DocumentClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClassifyDocumentResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<DocumentClass> classes;

    public List<DocumentClass> getClasses() {
        return this.classes;
    }

    public void setClasses(Collection<DocumentClass> classes) {
        if (classes == null) {
            this.classes = null;
            return;
        }
        this.classes = new ArrayList<DocumentClass>(classes);
    }

    public ClassifyDocumentResult withClasses(DocumentClass ... classes) {
        if (this.classes == null) {
            this.setClasses(new ArrayList<DocumentClass>(classes.length));
        }
        for (DocumentClass ele : classes) {
            this.classes.add(ele);
        }
        return this;
    }

    public ClassifyDocumentResult withClasses(Collection<DocumentClass> classes) {
        this.setClasses(classes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClasses() != null) {
            sb.append("Classes: ").append(this.getClasses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassifyDocumentResult)) {
            return false;
        }
        ClassifyDocumentResult other = (ClassifyDocumentResult)obj;
        if (other.getClasses() == null ^ this.getClasses() == null) {
            return false;
        }
        return other.getClasses() == null || other.getClasses().equals(this.getClasses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClasses() == null ? 0 : this.getClasses().hashCode());
        return hashCode;
    }

    public ClassifyDocumentResult clone() {
        try {
            return (ClassifyDocumentResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

