/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.PageBasedErrorCode;
import com.amazonaws.services.comprehend.model.transform.ErrorsListItemMarshaller;
import java.io.Serializable;

public class ErrorsListItem
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer page;
    private String errorCode;
    private String errorMessage;

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPage() {
        return this.page;
    }

    public ErrorsListItem withPage(Integer page) {
        this.setPage(page);
        return this;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public ErrorsListItem withErrorCode(String errorCode) {
        this.setErrorCode(errorCode);
        return this;
    }

    public ErrorsListItem withErrorCode(PageBasedErrorCode errorCode) {
        this.errorCode = errorCode.toString();
        return this;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public ErrorsListItem withErrorMessage(String errorMessage) {
        this.setErrorMessage(errorMessage);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPage() != null) {
            sb.append("Page: ").append(this.getPage()).append(",");
        }
        if (this.getErrorCode() != null) {
            sb.append("ErrorCode: ").append(this.getErrorCode()).append(",");
        }
        if (this.getErrorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.getErrorMessage());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorsListItem)) {
            return false;
        }
        ErrorsListItem other = (ErrorsListItem)obj;
        if (other.getPage() == null ^ this.getPage() == null) {
            return false;
        }
        if (other.getPage() != null && !other.getPage().equals(this.getPage())) {
            return false;
        }
        if (other.getErrorCode() == null ^ this.getErrorCode() == null) {
            return false;
        }
        if (other.getErrorCode() != null && !other.getErrorCode().equals(this.getErrorCode())) {
            return false;
        }
        if (other.getErrorMessage() == null ^ this.getErrorMessage() == null) {
            return false;
        }
        return other.getErrorMessage() == null || other.getErrorMessage().equals(this.getErrorMessage());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPage() == null ? 0 : this.getPage().hashCode());
        hashCode = 31 * hashCode + (this.getErrorCode() == null ? 0 : this.getErrorCode().hashCode());
        hashCode = 31 * hashCode + (this.getErrorMessage() == null ? 0 : this.getErrorMessage().hashCode());
        return hashCode;
    }

    public ErrorsListItem clone() {
        try {
            return (ErrorsListItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ErrorsListItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

