/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.comprehend;

import javax.annotation.Generated;

import com.amazonaws.services.comprehend.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonComprehend}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonComprehend implements AmazonComprehend {

    protected AbstractAmazonComprehend() {
    }

    @Override
    public BatchDetectDominantLanguageResult batchDetectDominantLanguage(BatchDetectDominantLanguageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDetectEntitiesResult batchDetectEntities(BatchDetectEntitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDetectKeyPhrasesResult batchDetectKeyPhrases(BatchDetectKeyPhrasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDetectSentimentResult batchDetectSentiment(BatchDetectSentimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDetectSyntaxResult batchDetectSyntax(BatchDetectSyntaxRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDetectTargetedSentimentResult batchDetectTargetedSentiment(BatchDetectTargetedSentimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ClassifyDocumentResult classifyDocument(ClassifyDocumentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ContainsPiiEntitiesResult containsPiiEntities(ContainsPiiEntitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatasetResult createDataset(CreateDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDocumentClassifierResult createDocumentClassifier(CreateDocumentClassifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEndpointResult createEndpoint(CreateEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEntityRecognizerResult createEntityRecognizer(CreateEntityRecognizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFlywheelResult createFlywheel(CreateFlywheelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDocumentClassifierResult deleteDocumentClassifier(DeleteDocumentClassifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEndpointResult deleteEndpoint(DeleteEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEntityRecognizerResult deleteEntityRecognizer(DeleteEntityRecognizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFlywheelResult deleteFlywheel(DeleteFlywheelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResourcePolicyResult deleteResourcePolicy(DeleteResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDatasetResult describeDataset(DescribeDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDocumentClassificationJobResult describeDocumentClassificationJob(DescribeDocumentClassificationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDocumentClassifierResult describeDocumentClassifier(DescribeDocumentClassifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDominantLanguageDetectionJobResult describeDominantLanguageDetectionJob(DescribeDominantLanguageDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEndpointResult describeEndpoint(DescribeEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEntitiesDetectionJobResult describeEntitiesDetectionJob(DescribeEntitiesDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEntityRecognizerResult describeEntityRecognizer(DescribeEntityRecognizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEventsDetectionJobResult describeEventsDetectionJob(DescribeEventsDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFlywheelResult describeFlywheel(DescribeFlywheelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFlywheelIterationResult describeFlywheelIteration(DescribeFlywheelIterationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeKeyPhrasesDetectionJobResult describeKeyPhrasesDetectionJob(DescribeKeyPhrasesDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePiiEntitiesDetectionJobResult describePiiEntitiesDetectionJob(DescribePiiEntitiesDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeResourcePolicyResult describeResourcePolicy(DescribeResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeSentimentDetectionJobResult describeSentimentDetectionJob(DescribeSentimentDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTargetedSentimentDetectionJobResult describeTargetedSentimentDetectionJob(DescribeTargetedSentimentDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTopicsDetectionJobResult describeTopicsDetectionJob(DescribeTopicsDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetectDominantLanguageResult detectDominantLanguage(DetectDominantLanguageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetectEntitiesResult detectEntities(DetectEntitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetectKeyPhrasesResult detectKeyPhrases(DetectKeyPhrasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetectPiiEntitiesResult detectPiiEntities(DetectPiiEntitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetectSentimentResult detectSentiment(DetectSentimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetectSyntaxResult detectSyntax(DetectSyntaxRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetectTargetedSentimentResult detectTargetedSentiment(DetectTargetedSentimentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ImportModelResult importModel(ImportModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatasetsResult listDatasets(ListDatasetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDocumentClassificationJobsResult listDocumentClassificationJobs(ListDocumentClassificationJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDocumentClassifierSummariesResult listDocumentClassifierSummaries(ListDocumentClassifierSummariesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDocumentClassifiersResult listDocumentClassifiers(ListDocumentClassifiersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDominantLanguageDetectionJobsResult listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEndpointsResult listEndpoints(ListEndpointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEntitiesDetectionJobsResult listEntitiesDetectionJobs(ListEntitiesDetectionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEntityRecognizerSummariesResult listEntityRecognizerSummaries(ListEntityRecognizerSummariesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEntityRecognizersResult listEntityRecognizers(ListEntityRecognizersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEventsDetectionJobsResult listEventsDetectionJobs(ListEventsDetectionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFlywheelIterationHistoryResult listFlywheelIterationHistory(ListFlywheelIterationHistoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFlywheelsResult listFlywheels(ListFlywheelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListKeyPhrasesDetectionJobsResult listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPiiEntitiesDetectionJobsResult listPiiEntitiesDetectionJobs(ListPiiEntitiesDetectionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSentimentDetectionJobsResult listSentimentDetectionJobs(ListSentimentDetectionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTargetedSentimentDetectionJobsResult listTargetedSentimentDetectionJobs(ListTargetedSentimentDetectionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTopicsDetectionJobsResult listTopicsDetectionJobs(ListTopicsDetectionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutResourcePolicyResult putResourcePolicy(PutResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartDocumentClassificationJobResult startDocumentClassificationJob(StartDocumentClassificationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartDominantLanguageDetectionJobResult startDominantLanguageDetectionJob(StartDominantLanguageDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartEntitiesDetectionJobResult startEntitiesDetectionJob(StartEntitiesDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartEventsDetectionJobResult startEventsDetectionJob(StartEventsDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartFlywheelIterationResult startFlywheelIteration(StartFlywheelIterationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartKeyPhrasesDetectionJobResult startKeyPhrasesDetectionJob(StartKeyPhrasesDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartPiiEntitiesDetectionJobResult startPiiEntitiesDetectionJob(StartPiiEntitiesDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartSentimentDetectionJobResult startSentimentDetectionJob(StartSentimentDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartTargetedSentimentDetectionJobResult startTargetedSentimentDetectionJob(StartTargetedSentimentDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartTopicsDetectionJobResult startTopicsDetectionJob(StartTopicsDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopDominantLanguageDetectionJobResult stopDominantLanguageDetectionJob(StopDominantLanguageDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopEntitiesDetectionJobResult stopEntitiesDetectionJob(StopEntitiesDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopEventsDetectionJobResult stopEventsDetectionJob(StopEventsDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopKeyPhrasesDetectionJobResult stopKeyPhrasesDetectionJob(StopKeyPhrasesDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopPiiEntitiesDetectionJobResult stopPiiEntitiesDetectionJob(StopPiiEntitiesDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopSentimentDetectionJobResult stopSentimentDetectionJob(StopSentimentDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopTargetedSentimentDetectionJobResult stopTargetedSentimentDetectionJob(StopTargetedSentimentDetectionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopTrainingDocumentClassifierResult stopTrainingDocumentClassifier(StopTrainingDocumentClassifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopTrainingEntityRecognizerResult stopTrainingEntityRecognizer(StopTrainingEntityRecognizerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEndpointResult updateEndpoint(UpdateEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFlywheelResult updateFlywheel(UpdateFlywheelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
