/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.comprehend.model.DocumentClass;
import com.amazonaws.services.comprehend.model.DocumentLabel;
import com.amazonaws.services.comprehend.model.DocumentMetadata;
import com.amazonaws.services.comprehend.model.DocumentTypeListItem;
import com.amazonaws.services.comprehend.model.ErrorsListItem;
import com.amazonaws.services.comprehend.model.WarningsListItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClassifyDocumentResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<DocumentClass> classes;
    private List<DocumentLabel> labels;
    private DocumentMetadata documentMetadata;
    private List<DocumentTypeListItem> documentType;
    private List<ErrorsListItem> errors;
    private List<WarningsListItem> warnings;

    public List<DocumentClass> getClasses() {
        return this.classes;
    }

    public void setClasses(Collection<DocumentClass> classes) {
        if (classes == null) {
            this.classes = null;
            return;
        }
        this.classes = new ArrayList<DocumentClass>(classes);
    }

    public ClassifyDocumentResult withClasses(DocumentClass ... classes) {
        if (this.classes == null) {
            this.setClasses(new ArrayList<DocumentClass>(classes.length));
        }
        for (DocumentClass ele : classes) {
            this.classes.add(ele);
        }
        return this;
    }

    public ClassifyDocumentResult withClasses(Collection<DocumentClass> classes) {
        this.setClasses(classes);
        return this;
    }

    public List<DocumentLabel> getLabels() {
        return this.labels;
    }

    public void setLabels(Collection<DocumentLabel> labels) {
        if (labels == null) {
            this.labels = null;
            return;
        }
        this.labels = new ArrayList<DocumentLabel>(labels);
    }

    public ClassifyDocumentResult withLabels(DocumentLabel ... labels) {
        if (this.labels == null) {
            this.setLabels(new ArrayList<DocumentLabel>(labels.length));
        }
        for (DocumentLabel ele : labels) {
            this.labels.add(ele);
        }
        return this;
    }

    public ClassifyDocumentResult withLabels(Collection<DocumentLabel> labels) {
        this.setLabels(labels);
        return this;
    }

    public void setDocumentMetadata(DocumentMetadata documentMetadata) {
        this.documentMetadata = documentMetadata;
    }

    public DocumentMetadata getDocumentMetadata() {
        return this.documentMetadata;
    }

    public ClassifyDocumentResult withDocumentMetadata(DocumentMetadata documentMetadata) {
        this.setDocumentMetadata(documentMetadata);
        return this;
    }

    public List<DocumentTypeListItem> getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(Collection<DocumentTypeListItem> documentType) {
        if (documentType == null) {
            this.documentType = null;
            return;
        }
        this.documentType = new ArrayList<DocumentTypeListItem>(documentType);
    }

    public ClassifyDocumentResult withDocumentType(DocumentTypeListItem ... documentType) {
        if (this.documentType == null) {
            this.setDocumentType(new ArrayList<DocumentTypeListItem>(documentType.length));
        }
        for (DocumentTypeListItem ele : documentType) {
            this.documentType.add(ele);
        }
        return this;
    }

    public ClassifyDocumentResult withDocumentType(Collection<DocumentTypeListItem> documentType) {
        this.setDocumentType(documentType);
        return this;
    }

    public List<ErrorsListItem> getErrors() {
        return this.errors;
    }

    public void setErrors(Collection<ErrorsListItem> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new ArrayList<ErrorsListItem>(errors);
    }

    public ClassifyDocumentResult withErrors(ErrorsListItem ... errors) {
        if (this.errors == null) {
            this.setErrors(new ArrayList<ErrorsListItem>(errors.length));
        }
        for (ErrorsListItem ele : errors) {
            this.errors.add(ele);
        }
        return this;
    }

    public ClassifyDocumentResult withErrors(Collection<ErrorsListItem> errors) {
        this.setErrors(errors);
        return this;
    }

    public List<WarningsListItem> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(Collection<WarningsListItem> warnings) {
        if (warnings == null) {
            this.warnings = null;
            return;
        }
        this.warnings = new ArrayList<WarningsListItem>(warnings);
    }

    public ClassifyDocumentResult withWarnings(WarningsListItem ... warnings) {
        if (this.warnings == null) {
            this.setWarnings(new ArrayList<WarningsListItem>(warnings.length));
        }
        for (WarningsListItem ele : warnings) {
            this.warnings.add(ele);
        }
        return this;
    }

    public ClassifyDocumentResult withWarnings(Collection<WarningsListItem> warnings) {
        this.setWarnings(warnings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClasses() != null) {
            sb.append("Classes: ").append(this.getClasses()).append(",");
        }
        if (this.getLabels() != null) {
            sb.append("Labels: ").append(this.getLabels()).append(",");
        }
        if (this.getDocumentMetadata() != null) {
            sb.append("DocumentMetadata: ").append(this.getDocumentMetadata()).append(",");
        }
        if (this.getDocumentType() != null) {
            sb.append("DocumentType: ").append(this.getDocumentType()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors()).append(",");
        }
        if (this.getWarnings() != null) {
            sb.append("Warnings: ").append(this.getWarnings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassifyDocumentResult)) {
            return false;
        }
        ClassifyDocumentResult other = (ClassifyDocumentResult)obj;
        if (other.getClasses() == null ^ this.getClasses() == null) {
            return false;
        }
        if (other.getClasses() != null && !other.getClasses().equals(this.getClasses())) {
            return false;
        }
        if (other.getLabels() == null ^ this.getLabels() == null) {
            return false;
        }
        if (other.getLabels() != null && !other.getLabels().equals(this.getLabels())) {
            return false;
        }
        if (other.getDocumentMetadata() == null ^ this.getDocumentMetadata() == null) {
            return false;
        }
        if (other.getDocumentMetadata() != null && !other.getDocumentMetadata().equals(this.getDocumentMetadata())) {
            return false;
        }
        if (other.getDocumentType() == null ^ this.getDocumentType() == null) {
            return false;
        }
        if (other.getDocumentType() != null && !other.getDocumentType().equals(this.getDocumentType())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        if (other.getErrors() != null && !other.getErrors().equals(this.getErrors())) {
            return false;
        }
        if (other.getWarnings() == null ^ this.getWarnings() == null) {
            return false;
        }
        return other.getWarnings() == null || other.getWarnings().equals(this.getWarnings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClasses() == null ? 0 : this.getClasses().hashCode());
        hashCode = 31 * hashCode + (this.getLabels() == null ? 0 : this.getLabels().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentMetadata() == null ? 0 : this.getDocumentMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentType() == null ? 0 : this.getDocumentType().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        hashCode = 31 * hashCode + (this.getWarnings() == null ? 0 : this.getWarnings().hashCode());
        return hashCode;
    }

    public ClassifyDocumentResult clone() {
        try {
            return (ClassifyDocumentResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

