/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.comprehend.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Document type for each page in the document.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DocumentTypeListItem" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DocumentTypeListItem implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Page number.
     * </p>
     */
    private Integer page;
    /**
     * <p>
     * Document type.
     * </p>
     */
    private String type;

    /**
     * <p>
     * Page number.
     * </p>
     * 
     * @param page
     *        Page number.
     */

    public void setPage(Integer page) {
        this.page = page;
    }

    /**
     * <p>
     * Page number.
     * </p>
     * 
     * @return Page number.
     */

    public Integer getPage() {
        return this.page;
    }

    /**
     * <p>
     * Page number.
     * </p>
     * 
     * @param page
     *        Page number.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DocumentTypeListItem withPage(Integer page) {
        setPage(page);
        return this;
    }

    /**
     * <p>
     * Document type.
     * </p>
     * 
     * @param type
     *        Document type.
     * @see DocumentType
     */

    public void setType(String type) {
        this.type = type;
    }

    /**
     * <p>
     * Document type.
     * </p>
     * 
     * @return Document type.
     * @see DocumentType
     */

    public String getType() {
        return this.type;
    }

    /**
     * <p>
     * Document type.
     * </p>
     * 
     * @param type
     *        Document type.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see DocumentType
     */

    public DocumentTypeListItem withType(String type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * Document type.
     * </p>
     * 
     * @param type
     *        Document type.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see DocumentType
     */

    public DocumentTypeListItem withType(DocumentType type) {
        this.type = type.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getPage() != null)
            sb.append("Page: ").append(getPage()).append(",");
        if (getType() != null)
            sb.append("Type: ").append(getType());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DocumentTypeListItem == false)
            return false;
        DocumentTypeListItem other = (DocumentTypeListItem) obj;
        if (other.getPage() == null ^ this.getPage() == null)
            return false;
        if (other.getPage() != null && other.getPage().equals(this.getPage()) == false)
            return false;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getPage() == null) ? 0 : getPage().hashCode());
        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        return hashCode;
    }

    @Override
    public DocumentTypeListItem clone() {
        try {
            return (DocumentTypeListItem) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.comprehend.model.transform.DocumentTypeListItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
