/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.comprehend.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The X and Y coordinates of a point on a document page.
 * </p>
 * <p>
 * For additional information, see <a href="https://docs.aws.amazon.com/textract/latest/dg/API_Point.html">Point</a> in
 * the Amazon Textract API reference.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/Point" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Point implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The value of the X coordinate for a point on a polygon
     * </p>
     */
    private Float x;
    /**
     * <p>
     * The value of the Y coordinate for a point on a polygon
     * </p>
     */
    private Float y;

    /**
     * <p>
     * The value of the X coordinate for a point on a polygon
     * </p>
     * 
     * @param x
     *        The value of the X coordinate for a point on a polygon
     */

    public void setX(Float x) {
        this.x = x;
    }

    /**
     * <p>
     * The value of the X coordinate for a point on a polygon
     * </p>
     * 
     * @return The value of the X coordinate for a point on a polygon
     */

    public Float getX() {
        return this.x;
    }

    /**
     * <p>
     * The value of the X coordinate for a point on a polygon
     * </p>
     * 
     * @param x
     *        The value of the X coordinate for a point on a polygon
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Point withX(Float x) {
        setX(x);
        return this;
    }

    /**
     * <p>
     * The value of the Y coordinate for a point on a polygon
     * </p>
     * 
     * @param y
     *        The value of the Y coordinate for a point on a polygon
     */

    public void setY(Float y) {
        this.y = y;
    }

    /**
     * <p>
     * The value of the Y coordinate for a point on a polygon
     * </p>
     * 
     * @return The value of the Y coordinate for a point on a polygon
     */

    public Float getY() {
        return this.y;
    }

    /**
     * <p>
     * The value of the Y coordinate for a point on a polygon
     * </p>
     * 
     * @param y
     *        The value of the Y coordinate for a point on a polygon
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Point withY(Float y) {
        setY(y);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getX() != null)
            sb.append("X: ").append(getX()).append(",");
        if (getY() != null)
            sb.append("Y: ").append(getY());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Point == false)
            return false;
        Point other = (Point) obj;
        if (other.getX() == null ^ this.getX() == null)
            return false;
        if (other.getX() != null && other.getX().equals(this.getX()) == false)
            return false;
        if (other.getY() == null ^ this.getY() == null)
            return false;
        if (other.getY() != null && other.getY().equals(this.getY()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getX() == null) ? 0 : getX().hashCode());
        hashCode = prime * hashCode + ((getY() == null) ? 0 : getY().hashCode());
        return hashCode;
    }

    @Override
    public Point clone() {
        try {
            return (Point) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.comprehend.model.transform.PointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
