/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.comprehend.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEntitiesDetectionJob"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class StartEntitiesDetectionJobResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The identifier generated for the job. To get the status of job, use this identifier with the operation.
     * </p>
     */
    private String jobId;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully qualified identifier for the
     * job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the
     * ARN is as follows:
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:entities-detection-job/&lt;job-id&gt;</code>
     * </p>
     * <p>
     * The following is an example job ARN:
     * </p>
     * <p>
     * <code>arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
     * </p>
     */
    private String jobArn;
    /**
     * <p>
     * The status of the job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * SUBMITTED - The job has been received and is queued for processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * IN_PROGRESS - Amazon Comprehend is processing the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED - The job was successfully completed and the output is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The job did not complete. To get details, use the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED - The job was successfully stopped without completing.
     * </p>
     * </li>
     * </ul>
     */
    private String jobStatus;
    /**
     * <p>
     * The ARN of the custom entity recognition model.
     * </p>
     */
    private String entityRecognizerArn;

    /**
     * <p>
     * The identifier generated for the job. To get the status of job, use this identifier with the operation.
     * </p>
     * 
     * @param jobId
     *        The identifier generated for the job. To get the status of job, use this identifier with the operation.
     */

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    /**
     * <p>
     * The identifier generated for the job. To get the status of job, use this identifier with the operation.
     * </p>
     * 
     * @return The identifier generated for the job. To get the status of job, use this identifier with the operation.
     */

    public String getJobId() {
        return this.jobId;
    }

    /**
     * <p>
     * The identifier generated for the job. To get the status of job, use this identifier with the operation.
     * </p>
     * 
     * @param jobId
     *        The identifier generated for the job. To get the status of job, use this identifier with the operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartEntitiesDetectionJobResult withJobId(String jobId) {
        setJobId(jobId);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully qualified identifier for the
     * job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the
     * ARN is as follows:
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:entities-detection-job/&lt;job-id&gt;</code>
     * </p>
     * <p>
     * The following is an example job ARN:
     * </p>
     * <p>
     * <code>arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
     * </p>
     * 
     * @param jobArn
     *        The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully qualified identifier
     *        for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The
     *        format of the ARN is as follows:</p>
     *        <p>
     *        <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:entities-detection-job/&lt;job-id&gt;</code>
     *        </p>
     *        <p>
     *        The following is an example job ARN:
     *        </p>
     *        <p>
     *        <code>arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
     */

    public void setJobArn(String jobArn) {
        this.jobArn = jobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully qualified identifier for the
     * job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the
     * ARN is as follows:
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:entities-detection-job/&lt;job-id&gt;</code>
     * </p>
     * <p>
     * The following is an example job ARN:
     * </p>
     * <p>
     * <code>arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully qualified identifier
     *         for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The
     *         format of the ARN is as follows:</p>
     *         <p>
     *         <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:entities-detection-job/&lt;job-id&gt;</code>
     *         </p>
     *         <p>
     *         The following is an example job ARN:
     *         </p>
     *         <p>
     *         <code>arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
     */

    public String getJobArn() {
        return this.jobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully qualified identifier for the
     * job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the
     * ARN is as follows:
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:entities-detection-job/&lt;job-id&gt;</code>
     * </p>
     * <p>
     * The following is an example job ARN:
     * </p>
     * <p>
     * <code>arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
     * </p>
     * 
     * @param jobArn
     *        The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully qualified identifier
     *        for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The
     *        format of the ARN is as follows:</p>
     *        <p>
     *        <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:entities-detection-job/&lt;job-id&gt;</code>
     *        </p>
     *        <p>
     *        The following is an example job ARN:
     *        </p>
     *        <p>
     *        <code>arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartEntitiesDetectionJobResult withJobArn(String jobArn) {
        setJobArn(jobArn);
        return this;
    }

    /**
     * <p>
     * The status of the job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * SUBMITTED - The job has been received and is queued for processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * IN_PROGRESS - Amazon Comprehend is processing the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED - The job was successfully completed and the output is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The job did not complete. To get details, use the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED - The job was successfully stopped without completing.
     * </p>
     * </li>
     * </ul>
     * 
     * @param jobStatus
     *        The status of the job. </p>
     *        <ul>
     *        <li>
     *        <p>
     *        SUBMITTED - The job has been received and is queued for processing.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        IN_PROGRESS - Amazon Comprehend is processing the job.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        COMPLETED - The job was successfully completed and the output is available.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        FAILED - The job did not complete. To get details, use the operation.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        STOPPED - The job was successfully stopped without completing.
     *        </p>
     *        </li>
     * @see JobStatus
     */

    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    /**
     * <p>
     * The status of the job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * SUBMITTED - The job has been received and is queued for processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * IN_PROGRESS - Amazon Comprehend is processing the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED - The job was successfully completed and the output is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The job did not complete. To get details, use the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED - The job was successfully stopped without completing.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the job. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SUBMITTED - The job has been received and is queued for processing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IN_PROGRESS - Amazon Comprehend is processing the job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED - The job was successfully completed and the output is available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED - The job did not complete. To get details, use the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED - The job was successfully stopped without completing.
     *         </p>
     *         </li>
     * @see JobStatus
     */

    public String getJobStatus() {
        return this.jobStatus;
    }

    /**
     * <p>
     * The status of the job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * SUBMITTED - The job has been received and is queued for processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * IN_PROGRESS - Amazon Comprehend is processing the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED - The job was successfully completed and the output is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The job did not complete. To get details, use the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED - The job was successfully stopped without completing.
     * </p>
     * </li>
     * </ul>
     * 
     * @param jobStatus
     *        The status of the job. </p>
     *        <ul>
     *        <li>
     *        <p>
     *        SUBMITTED - The job has been received and is queued for processing.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        IN_PROGRESS - Amazon Comprehend is processing the job.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        COMPLETED - The job was successfully completed and the output is available.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        FAILED - The job did not complete. To get details, use the operation.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        STOPPED - The job was successfully stopped without completing.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see JobStatus
     */

    public StartEntitiesDetectionJobResult withJobStatus(String jobStatus) {
        setJobStatus(jobStatus);
        return this;
    }

    /**
     * <p>
     * The status of the job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * SUBMITTED - The job has been received and is queued for processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * IN_PROGRESS - Amazon Comprehend is processing the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED - The job was successfully completed and the output is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The job did not complete. To get details, use the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED - The job was successfully stopped without completing.
     * </p>
     * </li>
     * </ul>
     * 
     * @param jobStatus
     *        The status of the job. </p>
     *        <ul>
     *        <li>
     *        <p>
     *        SUBMITTED - The job has been received and is queued for processing.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        IN_PROGRESS - Amazon Comprehend is processing the job.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        COMPLETED - The job was successfully completed and the output is available.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        FAILED - The job did not complete. To get details, use the operation.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        STOPPED - The job was successfully stopped without completing.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see JobStatus
     */

    public StartEntitiesDetectionJobResult withJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus.toString();
        return this;
    }

    /**
     * <p>
     * The ARN of the custom entity recognition model.
     * </p>
     * 
     * @param entityRecognizerArn
     *        The ARN of the custom entity recognition model.
     */

    public void setEntityRecognizerArn(String entityRecognizerArn) {
        this.entityRecognizerArn = entityRecognizerArn;
    }

    /**
     * <p>
     * The ARN of the custom entity recognition model.
     * </p>
     * 
     * @return The ARN of the custom entity recognition model.
     */

    public String getEntityRecognizerArn() {
        return this.entityRecognizerArn;
    }

    /**
     * <p>
     * The ARN of the custom entity recognition model.
     * </p>
     * 
     * @param entityRecognizerArn
     *        The ARN of the custom entity recognition model.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StartEntitiesDetectionJobResult withEntityRecognizerArn(String entityRecognizerArn) {
        setEntityRecognizerArn(entityRecognizerArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getJobId() != null)
            sb.append("JobId: ").append(getJobId()).append(",");
        if (getJobArn() != null)
            sb.append("JobArn: ").append(getJobArn()).append(",");
        if (getJobStatus() != null)
            sb.append("JobStatus: ").append(getJobStatus()).append(",");
        if (getEntityRecognizerArn() != null)
            sb.append("EntityRecognizerArn: ").append(getEntityRecognizerArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof StartEntitiesDetectionJobResult == false)
            return false;
        StartEntitiesDetectionJobResult other = (StartEntitiesDetectionJobResult) obj;
        if (other.getJobId() == null ^ this.getJobId() == null)
            return false;
        if (other.getJobId() != null && other.getJobId().equals(this.getJobId()) == false)
            return false;
        if (other.getJobArn() == null ^ this.getJobArn() == null)
            return false;
        if (other.getJobArn() != null && other.getJobArn().equals(this.getJobArn()) == false)
            return false;
        if (other.getJobStatus() == null ^ this.getJobStatus() == null)
            return false;
        if (other.getJobStatus() != null && other.getJobStatus().equals(this.getJobStatus()) == false)
            return false;
        if (other.getEntityRecognizerArn() == null ^ this.getEntityRecognizerArn() == null)
            return false;
        if (other.getEntityRecognizerArn() != null && other.getEntityRecognizerArn().equals(this.getEntityRecognizerArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getJobId() == null) ? 0 : getJobId().hashCode());
        hashCode = prime * hashCode + ((getJobArn() == null) ? 0 : getJobArn().hashCode());
        hashCode = prime * hashCode + ((getJobStatus() == null) ? 0 : getJobStatus().hashCode());
        hashCode = prime * hashCode + ((getEntityRecognizerArn() == null) ? 0 : getEntityRecognizerArn().hashCode());
        return hashCode;
    }

    @Override
    public StartEntitiesDetectionJobResult clone() {
        try {
            return (StartEntitiesDetectionJobResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
