/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.comprehendmedical.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The SNOMED-CT concepts that the entity could refer to, along with a score indicating the likelihood of the match.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/SNOMEDCTConcept" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SNOMEDCTConcept implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The description of the SNOMED-CT concept.
     * </p>
     */
    private String description;
    /**
     * <p>
     * The numeric ID for the SNOMED-CT concept.
     * </p>
     */
    private String code;
    /**
     * <p>
     * The level of confidence Comprehend Medical has that the entity should be linked to the identified SNOMED-CT
     * concept.
     * </p>
     */
    private Float score;

    /**
     * <p>
     * The description of the SNOMED-CT concept.
     * </p>
     * 
     * @param description
     *        The description of the SNOMED-CT concept.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * The description of the SNOMED-CT concept.
     * </p>
     * 
     * @return The description of the SNOMED-CT concept.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * The description of the SNOMED-CT concept.
     * </p>
     * 
     * @param description
     *        The description of the SNOMED-CT concept.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SNOMEDCTConcept withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * The numeric ID for the SNOMED-CT concept.
     * </p>
     * 
     * @param code
     *        The numeric ID for the SNOMED-CT concept.
     */

    public void setCode(String code) {
        this.code = code;
    }

    /**
     * <p>
     * The numeric ID for the SNOMED-CT concept.
     * </p>
     * 
     * @return The numeric ID for the SNOMED-CT concept.
     */

    public String getCode() {
        return this.code;
    }

    /**
     * <p>
     * The numeric ID for the SNOMED-CT concept.
     * </p>
     * 
     * @param code
     *        The numeric ID for the SNOMED-CT concept.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SNOMEDCTConcept withCode(String code) {
        setCode(code);
        return this;
    }

    /**
     * <p>
     * The level of confidence Comprehend Medical has that the entity should be linked to the identified SNOMED-CT
     * concept.
     * </p>
     * 
     * @param score
     *        The level of confidence Comprehend Medical has that the entity should be linked to the identified
     *        SNOMED-CT concept.
     */

    public void setScore(Float score) {
        this.score = score;
    }

    /**
     * <p>
     * The level of confidence Comprehend Medical has that the entity should be linked to the identified SNOMED-CT
     * concept.
     * </p>
     * 
     * @return The level of confidence Comprehend Medical has that the entity should be linked to the identified
     *         SNOMED-CT concept.
     */

    public Float getScore() {
        return this.score;
    }

    /**
     * <p>
     * The level of confidence Comprehend Medical has that the entity should be linked to the identified SNOMED-CT
     * concept.
     * </p>
     * 
     * @param score
     *        The level of confidence Comprehend Medical has that the entity should be linked to the identified
     *        SNOMED-CT concept.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SNOMEDCTConcept withScore(Float score) {
        setScore(score);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getCode() != null)
            sb.append("Code: ").append(getCode()).append(",");
        if (getScore() != null)
            sb.append("Score: ").append(getScore());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SNOMEDCTConcept == false)
            return false;
        SNOMEDCTConcept other = (SNOMEDCTConcept) obj;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getCode() == null ^ this.getCode() == null)
            return false;
        if (other.getCode() != null && other.getCode().equals(this.getCode()) == false)
            return false;
        if (other.getScore() == null ^ this.getScore() == null)
            return false;
        if (other.getScore() != null && other.getScore().equals(this.getScore()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getCode() == null) ? 0 : getCode().hashCode());
        hashCode = prime * hashCode + ((getScore() == null) ? 0 : getScore().hashCode());
        return hashCode;
    }

    @Override
    public SNOMEDCTConcept clone() {
        try {
            return (SNOMEDCTConcept) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.comprehendmedical.model.transform.SNOMEDCTConceptMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
