/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.computeoptimizer.model.S3Destination;

@SdkInternalApi
public class S3DestinationMarshaller {
    private static final MarshallingInfo<String> BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucket").build();
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("key").build();
    private static final MarshallingInfo<String> METADATAKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metadataKey").build();
    private static final S3DestinationMarshaller instance = new S3DestinationMarshaller();

    public static S3DestinationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Destination s3Destination, ProtocolMarshaller protocolMarshaller) {
        if (s3Destination == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3Destination.getBucket(), BUCKET_BINDING);
            protocolMarshaller.marshall((Object)s3Destination.getKey(), KEY_BINDING);
            protocolMarshaller.marshall((Object)s3Destination.getMetadataKey(), METADATAKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

