/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.PlatformDifference;
import com.amazonaws.services.computeoptimizer.model.SavingsOpportunity;
import com.amazonaws.services.computeoptimizer.model.UtilizationMetric;
import com.amazonaws.services.computeoptimizer.model.transform.InstanceRecommendationOptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InstanceRecommendationOption
implements Serializable,
Cloneable,
StructuredPojo {
    private String instanceType;
    private List<UtilizationMetric> projectedUtilizationMetrics;
    private List<String> platformDifferences;
    private Double performanceRisk;
    private Integer rank;
    private SavingsOpportunity savingsOpportunity;

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public InstanceRecommendationOption withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public List<UtilizationMetric> getProjectedUtilizationMetrics() {
        return this.projectedUtilizationMetrics;
    }

    public void setProjectedUtilizationMetrics(Collection<UtilizationMetric> projectedUtilizationMetrics) {
        if (projectedUtilizationMetrics == null) {
            this.projectedUtilizationMetrics = null;
            return;
        }
        this.projectedUtilizationMetrics = new ArrayList<UtilizationMetric>(projectedUtilizationMetrics);
    }

    public InstanceRecommendationOption withProjectedUtilizationMetrics(UtilizationMetric ... projectedUtilizationMetrics) {
        if (this.projectedUtilizationMetrics == null) {
            this.setProjectedUtilizationMetrics(new ArrayList<UtilizationMetric>(projectedUtilizationMetrics.length));
        }
        for (UtilizationMetric ele : projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics.add(ele);
        }
        return this;
    }

    public InstanceRecommendationOption withProjectedUtilizationMetrics(Collection<UtilizationMetric> projectedUtilizationMetrics) {
        this.setProjectedUtilizationMetrics(projectedUtilizationMetrics);
        return this;
    }

    public List<String> getPlatformDifferences() {
        return this.platformDifferences;
    }

    public void setPlatformDifferences(Collection<String> platformDifferences) {
        if (platformDifferences == null) {
            this.platformDifferences = null;
            return;
        }
        this.platformDifferences = new ArrayList<String>(platformDifferences);
    }

    public InstanceRecommendationOption withPlatformDifferences(String ... platformDifferences) {
        if (this.platformDifferences == null) {
            this.setPlatformDifferences(new ArrayList<String>(platformDifferences.length));
        }
        for (String ele : platformDifferences) {
            this.platformDifferences.add(ele);
        }
        return this;
    }

    public InstanceRecommendationOption withPlatformDifferences(Collection<String> platformDifferences) {
        this.setPlatformDifferences(platformDifferences);
        return this;
    }

    public InstanceRecommendationOption withPlatformDifferences(PlatformDifference ... platformDifferences) {
        ArrayList<String> platformDifferencesCopy = new ArrayList<String>(platformDifferences.length);
        for (PlatformDifference value : platformDifferences) {
            platformDifferencesCopy.add(value.toString());
        }
        if (this.getPlatformDifferences() == null) {
            this.setPlatformDifferences(platformDifferencesCopy);
        } else {
            this.getPlatformDifferences().addAll(platformDifferencesCopy);
        }
        return this;
    }

    public void setPerformanceRisk(Double performanceRisk) {
        this.performanceRisk = performanceRisk;
    }

    public Double getPerformanceRisk() {
        return this.performanceRisk;
    }

    public InstanceRecommendationOption withPerformanceRisk(Double performanceRisk) {
        this.setPerformanceRisk(performanceRisk);
        return this;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public Integer getRank() {
        return this.rank;
    }

    public InstanceRecommendationOption withRank(Integer rank) {
        this.setRank(rank);
        return this;
    }

    public void setSavingsOpportunity(SavingsOpportunity savingsOpportunity) {
        this.savingsOpportunity = savingsOpportunity;
    }

    public SavingsOpportunity getSavingsOpportunity() {
        return this.savingsOpportunity;
    }

    public InstanceRecommendationOption withSavingsOpportunity(SavingsOpportunity savingsOpportunity) {
        this.setSavingsOpportunity(savingsOpportunity);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getProjectedUtilizationMetrics() != null) {
            sb.append("ProjectedUtilizationMetrics: ").append(this.getProjectedUtilizationMetrics()).append(",");
        }
        if (this.getPlatformDifferences() != null) {
            sb.append("PlatformDifferences: ").append(this.getPlatformDifferences()).append(",");
        }
        if (this.getPerformanceRisk() != null) {
            sb.append("PerformanceRisk: ").append(this.getPerformanceRisk()).append(",");
        }
        if (this.getRank() != null) {
            sb.append("Rank: ").append(this.getRank()).append(",");
        }
        if (this.getSavingsOpportunity() != null) {
            sb.append("SavingsOpportunity: ").append(this.getSavingsOpportunity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceRecommendationOption)) {
            return false;
        }
        InstanceRecommendationOption other = (InstanceRecommendationOption)obj;
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getProjectedUtilizationMetrics() == null ^ this.getProjectedUtilizationMetrics() == null) {
            return false;
        }
        if (other.getProjectedUtilizationMetrics() != null && !other.getProjectedUtilizationMetrics().equals(this.getProjectedUtilizationMetrics())) {
            return false;
        }
        if (other.getPlatformDifferences() == null ^ this.getPlatformDifferences() == null) {
            return false;
        }
        if (other.getPlatformDifferences() != null && !other.getPlatformDifferences().equals(this.getPlatformDifferences())) {
            return false;
        }
        if (other.getPerformanceRisk() == null ^ this.getPerformanceRisk() == null) {
            return false;
        }
        if (other.getPerformanceRisk() != null && !other.getPerformanceRisk().equals(this.getPerformanceRisk())) {
            return false;
        }
        if (other.getRank() == null ^ this.getRank() == null) {
            return false;
        }
        if (other.getRank() != null && !other.getRank().equals(this.getRank())) {
            return false;
        }
        if (other.getSavingsOpportunity() == null ^ this.getSavingsOpportunity() == null) {
            return false;
        }
        return other.getSavingsOpportunity() == null || other.getSavingsOpportunity().equals(this.getSavingsOpportunity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getProjectedUtilizationMetrics() == null ? 0 : this.getProjectedUtilizationMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformDifferences() == null ? 0 : this.getPlatformDifferences().hashCode());
        hashCode = 31 * hashCode + (this.getPerformanceRisk() == null ? 0 : this.getPerformanceRisk().hashCode());
        hashCode = 31 * hashCode + (this.getRank() == null ? 0 : this.getRank().hashCode());
        hashCode = 31 * hashCode + (this.getSavingsOpportunity() == null ? 0 : this.getSavingsOpportunity().hashCode());
        return hashCode;
    }

    public InstanceRecommendationOption clone() {
        try {
            return (InstanceRecommendationOption)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceRecommendationOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

