/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.ECSServiceProjectedMetric;
import com.amazonaws.services.computeoptimizer.model.transform.ECSServiceRecommendedOptionProjectedMetricMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ECSServiceRecommendedOptionProjectedMetric
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer recommendedCpuUnits;
    private Integer recommendedMemorySize;
    private List<ECSServiceProjectedMetric> projectedMetrics;

    public void setRecommendedCpuUnits(Integer recommendedCpuUnits) {
        this.recommendedCpuUnits = recommendedCpuUnits;
    }

    public Integer getRecommendedCpuUnits() {
        return this.recommendedCpuUnits;
    }

    public ECSServiceRecommendedOptionProjectedMetric withRecommendedCpuUnits(Integer recommendedCpuUnits) {
        this.setRecommendedCpuUnits(recommendedCpuUnits);
        return this;
    }

    public void setRecommendedMemorySize(Integer recommendedMemorySize) {
        this.recommendedMemorySize = recommendedMemorySize;
    }

    public Integer getRecommendedMemorySize() {
        return this.recommendedMemorySize;
    }

    public ECSServiceRecommendedOptionProjectedMetric withRecommendedMemorySize(Integer recommendedMemorySize) {
        this.setRecommendedMemorySize(recommendedMemorySize);
        return this;
    }

    public List<ECSServiceProjectedMetric> getProjectedMetrics() {
        return this.projectedMetrics;
    }

    public void setProjectedMetrics(Collection<ECSServiceProjectedMetric> projectedMetrics) {
        if (projectedMetrics == null) {
            this.projectedMetrics = null;
            return;
        }
        this.projectedMetrics = new ArrayList<ECSServiceProjectedMetric>(projectedMetrics);
    }

    public ECSServiceRecommendedOptionProjectedMetric withProjectedMetrics(ECSServiceProjectedMetric ... projectedMetrics) {
        if (this.projectedMetrics == null) {
            this.setProjectedMetrics(new ArrayList<ECSServiceProjectedMetric>(projectedMetrics.length));
        }
        for (ECSServiceProjectedMetric ele : projectedMetrics) {
            this.projectedMetrics.add(ele);
        }
        return this;
    }

    public ECSServiceRecommendedOptionProjectedMetric withProjectedMetrics(Collection<ECSServiceProjectedMetric> projectedMetrics) {
        this.setProjectedMetrics(projectedMetrics);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecommendedCpuUnits() != null) {
            sb.append("RecommendedCpuUnits: ").append(this.getRecommendedCpuUnits()).append(",");
        }
        if (this.getRecommendedMemorySize() != null) {
            sb.append("RecommendedMemorySize: ").append(this.getRecommendedMemorySize()).append(",");
        }
        if (this.getProjectedMetrics() != null) {
            sb.append("ProjectedMetrics: ").append(this.getProjectedMetrics());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ECSServiceRecommendedOptionProjectedMetric)) {
            return false;
        }
        ECSServiceRecommendedOptionProjectedMetric other = (ECSServiceRecommendedOptionProjectedMetric)obj;
        if (other.getRecommendedCpuUnits() == null ^ this.getRecommendedCpuUnits() == null) {
            return false;
        }
        if (other.getRecommendedCpuUnits() != null && !other.getRecommendedCpuUnits().equals(this.getRecommendedCpuUnits())) {
            return false;
        }
        if (other.getRecommendedMemorySize() == null ^ this.getRecommendedMemorySize() == null) {
            return false;
        }
        if (other.getRecommendedMemorySize() != null && !other.getRecommendedMemorySize().equals(this.getRecommendedMemorySize())) {
            return false;
        }
        if (other.getProjectedMetrics() == null ^ this.getProjectedMetrics() == null) {
            return false;
        }
        return other.getProjectedMetrics() == null || other.getProjectedMetrics().equals(this.getProjectedMetrics());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecommendedCpuUnits() == null ? 0 : this.getRecommendedCpuUnits().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendedMemorySize() == null ? 0 : this.getRecommendedMemorySize().hashCode());
        hashCode = 31 * hashCode + (this.getProjectedMetrics() == null ? 0 : this.getProjectedMetrics().hashCode());
        return hashCode;
    }

    public ECSServiceRecommendedOptionProjectedMetric clone() {
        try {
            return (ECSServiceRecommendedOptionProjectedMetric)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ECSServiceRecommendedOptionProjectedMetricMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

