/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.CurrentPerformanceRisk;
import com.amazonaws.services.computeoptimizer.model.EBSFinding;
import com.amazonaws.services.computeoptimizer.model.EBSUtilizationMetric;
import com.amazonaws.services.computeoptimizer.model.Tag;
import com.amazonaws.services.computeoptimizer.model.VolumeConfiguration;
import com.amazonaws.services.computeoptimizer.model.VolumeRecommendationOption;
import com.amazonaws.services.computeoptimizer.model.transform.VolumeRecommendationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class VolumeRecommendation
implements Serializable,
Cloneable,
StructuredPojo {
    private String volumeArn;
    private String accountId;
    private VolumeConfiguration currentConfiguration;
    private String finding;
    private List<EBSUtilizationMetric> utilizationMetrics;
    private Double lookBackPeriodInDays;
    private List<VolumeRecommendationOption> volumeRecommendationOptions;
    private Date lastRefreshTimestamp;
    private String currentPerformanceRisk;
    private List<Tag> tags;

    public void setVolumeArn(String volumeArn) {
        this.volumeArn = volumeArn;
    }

    public String getVolumeArn() {
        return this.volumeArn;
    }

    public VolumeRecommendation withVolumeArn(String volumeArn) {
        this.setVolumeArn(volumeArn);
        return this;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public VolumeRecommendation withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setCurrentConfiguration(VolumeConfiguration currentConfiguration) {
        this.currentConfiguration = currentConfiguration;
    }

    public VolumeConfiguration getCurrentConfiguration() {
        return this.currentConfiguration;
    }

    public VolumeRecommendation withCurrentConfiguration(VolumeConfiguration currentConfiguration) {
        this.setCurrentConfiguration(currentConfiguration);
        return this;
    }

    public void setFinding(String finding) {
        this.finding = finding;
    }

    public String getFinding() {
        return this.finding;
    }

    public VolumeRecommendation withFinding(String finding) {
        this.setFinding(finding);
        return this;
    }

    public VolumeRecommendation withFinding(EBSFinding finding) {
        this.finding = finding.toString();
        return this;
    }

    public List<EBSUtilizationMetric> getUtilizationMetrics() {
        return this.utilizationMetrics;
    }

    public void setUtilizationMetrics(Collection<EBSUtilizationMetric> utilizationMetrics) {
        if (utilizationMetrics == null) {
            this.utilizationMetrics = null;
            return;
        }
        this.utilizationMetrics = new ArrayList<EBSUtilizationMetric>(utilizationMetrics);
    }

    public VolumeRecommendation withUtilizationMetrics(EBSUtilizationMetric ... utilizationMetrics) {
        if (this.utilizationMetrics == null) {
            this.setUtilizationMetrics(new ArrayList<EBSUtilizationMetric>(utilizationMetrics.length));
        }
        for (EBSUtilizationMetric ele : utilizationMetrics) {
            this.utilizationMetrics.add(ele);
        }
        return this;
    }

    public VolumeRecommendation withUtilizationMetrics(Collection<EBSUtilizationMetric> utilizationMetrics) {
        this.setUtilizationMetrics(utilizationMetrics);
        return this;
    }

    public void setLookBackPeriodInDays(Double lookBackPeriodInDays) {
        this.lookBackPeriodInDays = lookBackPeriodInDays;
    }

    public Double getLookBackPeriodInDays() {
        return this.lookBackPeriodInDays;
    }

    public VolumeRecommendation withLookBackPeriodInDays(Double lookBackPeriodInDays) {
        this.setLookBackPeriodInDays(lookBackPeriodInDays);
        return this;
    }

    public List<VolumeRecommendationOption> getVolumeRecommendationOptions() {
        return this.volumeRecommendationOptions;
    }

    public void setVolumeRecommendationOptions(Collection<VolumeRecommendationOption> volumeRecommendationOptions) {
        if (volumeRecommendationOptions == null) {
            this.volumeRecommendationOptions = null;
            return;
        }
        this.volumeRecommendationOptions = new ArrayList<VolumeRecommendationOption>(volumeRecommendationOptions);
    }

    public VolumeRecommendation withVolumeRecommendationOptions(VolumeRecommendationOption ... volumeRecommendationOptions) {
        if (this.volumeRecommendationOptions == null) {
            this.setVolumeRecommendationOptions(new ArrayList<VolumeRecommendationOption>(volumeRecommendationOptions.length));
        }
        for (VolumeRecommendationOption ele : volumeRecommendationOptions) {
            this.volumeRecommendationOptions.add(ele);
        }
        return this;
    }

    public VolumeRecommendation withVolumeRecommendationOptions(Collection<VolumeRecommendationOption> volumeRecommendationOptions) {
        this.setVolumeRecommendationOptions(volumeRecommendationOptions);
        return this;
    }

    public void setLastRefreshTimestamp(Date lastRefreshTimestamp) {
        this.lastRefreshTimestamp = lastRefreshTimestamp;
    }

    public Date getLastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public VolumeRecommendation withLastRefreshTimestamp(Date lastRefreshTimestamp) {
        this.setLastRefreshTimestamp(lastRefreshTimestamp);
        return this;
    }

    public void setCurrentPerformanceRisk(String currentPerformanceRisk) {
        this.currentPerformanceRisk = currentPerformanceRisk;
    }

    public String getCurrentPerformanceRisk() {
        return this.currentPerformanceRisk;
    }

    public VolumeRecommendation withCurrentPerformanceRisk(String currentPerformanceRisk) {
        this.setCurrentPerformanceRisk(currentPerformanceRisk);
        return this;
    }

    public VolumeRecommendation withCurrentPerformanceRisk(CurrentPerformanceRisk currentPerformanceRisk) {
        this.currentPerformanceRisk = currentPerformanceRisk.toString();
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public VolumeRecommendation withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public VolumeRecommendation withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVolumeArn() != null) {
            sb.append("VolumeArn: ").append(this.getVolumeArn()).append(",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getCurrentConfiguration() != null) {
            sb.append("CurrentConfiguration: ").append(this.getCurrentConfiguration()).append(",");
        }
        if (this.getFinding() != null) {
            sb.append("Finding: ").append(this.getFinding()).append(",");
        }
        if (this.getUtilizationMetrics() != null) {
            sb.append("UtilizationMetrics: ").append(this.getUtilizationMetrics()).append(",");
        }
        if (this.getLookBackPeriodInDays() != null) {
            sb.append("LookBackPeriodInDays: ").append(this.getLookBackPeriodInDays()).append(",");
        }
        if (this.getVolumeRecommendationOptions() != null) {
            sb.append("VolumeRecommendationOptions: ").append(this.getVolumeRecommendationOptions()).append(",");
        }
        if (this.getLastRefreshTimestamp() != null) {
            sb.append("LastRefreshTimestamp: ").append(this.getLastRefreshTimestamp()).append(",");
        }
        if (this.getCurrentPerformanceRisk() != null) {
            sb.append("CurrentPerformanceRisk: ").append(this.getCurrentPerformanceRisk()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeRecommendation)) {
            return false;
        }
        VolumeRecommendation other = (VolumeRecommendation)obj;
        if (other.getVolumeArn() == null ^ this.getVolumeArn() == null) {
            return false;
        }
        if (other.getVolumeArn() != null && !other.getVolumeArn().equals(this.getVolumeArn())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getCurrentConfiguration() == null ^ this.getCurrentConfiguration() == null) {
            return false;
        }
        if (other.getCurrentConfiguration() != null && !other.getCurrentConfiguration().equals(this.getCurrentConfiguration())) {
            return false;
        }
        if (other.getFinding() == null ^ this.getFinding() == null) {
            return false;
        }
        if (other.getFinding() != null && !other.getFinding().equals(this.getFinding())) {
            return false;
        }
        if (other.getUtilizationMetrics() == null ^ this.getUtilizationMetrics() == null) {
            return false;
        }
        if (other.getUtilizationMetrics() != null && !other.getUtilizationMetrics().equals(this.getUtilizationMetrics())) {
            return false;
        }
        if (other.getLookBackPeriodInDays() == null ^ this.getLookBackPeriodInDays() == null) {
            return false;
        }
        if (other.getLookBackPeriodInDays() != null && !other.getLookBackPeriodInDays().equals(this.getLookBackPeriodInDays())) {
            return false;
        }
        if (other.getVolumeRecommendationOptions() == null ^ this.getVolumeRecommendationOptions() == null) {
            return false;
        }
        if (other.getVolumeRecommendationOptions() != null && !other.getVolumeRecommendationOptions().equals(this.getVolumeRecommendationOptions())) {
            return false;
        }
        if (other.getLastRefreshTimestamp() == null ^ this.getLastRefreshTimestamp() == null) {
            return false;
        }
        if (other.getLastRefreshTimestamp() != null && !other.getLastRefreshTimestamp().equals(this.getLastRefreshTimestamp())) {
            return false;
        }
        if (other.getCurrentPerformanceRisk() == null ^ this.getCurrentPerformanceRisk() == null) {
            return false;
        }
        if (other.getCurrentPerformanceRisk() != null && !other.getCurrentPerformanceRisk().equals(this.getCurrentPerformanceRisk())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVolumeArn() == null ? 0 : this.getVolumeArn().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentConfiguration() == null ? 0 : this.getCurrentConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getFinding() == null ? 0 : this.getFinding().hashCode());
        hashCode = 31 * hashCode + (this.getUtilizationMetrics() == null ? 0 : this.getUtilizationMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getLookBackPeriodInDays() == null ? 0 : this.getLookBackPeriodInDays().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeRecommendationOptions() == null ? 0 : this.getVolumeRecommendationOptions().hashCode());
        hashCode = 31 * hashCode + (this.getLastRefreshTimestamp() == null ? 0 : this.getLastRefreshTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentPerformanceRisk() == null ? 0 : this.getCurrentPerformanceRisk().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public VolumeRecommendation clone() {
        try {
            return (VolumeRecommendation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VolumeRecommendationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

