/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.computeoptimizer.model;

import javax.annotation.Generated;

/**
 * 
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public enum ExternalMetricStatusCode {

    NO_EXTERNAL_METRIC_SET("NO_EXTERNAL_METRIC_SET"),
    INTEGRATION_SUCCESS("INTEGRATION_SUCCESS"),
    DATADOG_INTEGRATION_ERROR("DATADOG_INTEGRATION_ERROR"),
    DYNATRACE_INTEGRATION_ERROR("DYNATRACE_INTEGRATION_ERROR"),
    NEWRELIC_INTEGRATION_ERROR("NEWRELIC_INTEGRATION_ERROR"),
    INSTANA_INTEGRATION_ERROR("INSTANA_INTEGRATION_ERROR"),
    INSUFFICIENT_DATADOG_METRICS("INSUFFICIENT_DATADOG_METRICS"),
    INSUFFICIENT_DYNATRACE_METRICS("INSUFFICIENT_DYNATRACE_METRICS"),
    INSUFFICIENT_NEWRELIC_METRICS("INSUFFICIENT_NEWRELIC_METRICS"),
    INSUFFICIENT_INSTANA_METRICS("INSUFFICIENT_INSTANA_METRICS");

    private String value;

    private ExternalMetricStatusCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return ExternalMetricStatusCode corresponding to the value
     *
     * @throws IllegalArgumentException
     *         If the specified value does not map to one of the known values in this enum.
     */
    public static ExternalMetricStatusCode fromValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }

        for (ExternalMetricStatusCode enumEntry : ExternalMetricStatusCode.values()) {
            if (enumEntry.toString().equals(value)) {
                return enumEntry;
            }
        }

        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }
}
